/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.rejection;

import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.rejection.RejectedClassException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class MainMethodChecker
extends ClassToolchain.ToolChainClassVisitor {
    private static final int MAIN_MODIFIERS = 9;
    private static final String MAIN_METHOD_NAME = "main";
    private static final String MAIN_METHOD_DESCRIPTOR = "()[B";
    private boolean didFindMain;

    public static boolean checkForMain(byte[] bytecode) {
        MainMethodChecker methodChecker = new MainMethodChecker();
        try {
            new ClassToolchain.Builder(bytecode, 0).addNextVisitor(methodChecker).addWriter(new ClassWriter(0)).build().runAndGetBytecode();
        }
        catch (Exception e) {
            throw new RejectedClassException("Error when reading main method of main class: " + e.getMessage());
        }
        return methodChecker.didFindMain;
    }

    private MainMethodChecker() {
        super(458752);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (MAIN_METHOD_NAME.equals(name) && 9 == (access & 9) && MAIN_METHOD_DESCRIPTOR.equals(descriptor)) {
            this.didFindMain = true;
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }
}

