/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.rejection;

import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.miscvisitors.NamespaceMapper;
import org.aion.avm.core.miscvisitors.PreRenameClassAccessRules;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.rejection.RejectionAnnotationVisitor;
import org.aion.avm.core.util.MethodDescriptorCollector;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class RejectionMethodVisitor
extends MethodVisitor {
    private final PreRenameClassAccessRules classAccessRules;
    private final NamespaceMapper namespaceMapper;
    private final boolean preserveDebuggability;

    public RejectionMethodVisitor(MethodVisitor visitor, PreRenameClassAccessRules classAccessRules, NamespaceMapper namespaceMapper, boolean preserveDebuggability) {
        super(458752, visitor);
        this.classAccessRules = classAccessRules;
        this.namespaceMapper = namespaceMapper;
        this.preserveDebuggability = preserveDebuggability;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new RejectionAnnotationVisitor();
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitInsn(int opcode) {
        this.checkOpcode(opcode);
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.checkOpcode(opcode);
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.checkOpcode(opcode);
        super.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.checkOpcode(opcode);
        super.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.checkOpcode(opcode);
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        if (this.classAccessRules.canUserAccessClass(owner)) {
            boolean didMatch;
            if (!isInterface && this.classAccessRules.isJclClass(owner) && !(didMatch = this.checkJclMethodExists(owner, name, descriptor))) {
                RejectedClassException.jclMethodNotImplemented(owner, name, descriptor);
            }
        } else {
            RejectedClassException.notAllowedClass(owner);
        }
        this.checkOpcode(opcode);
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.checkOpcode(opcode);
        super.visitJumpInsn(opcode, label);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        if (this.preserveDebuggability) {
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
        }
    }

    public void visitLineNumber(int line, Label start) {
        if (this.preserveDebuggability) {
            super.visitLineNumber(line, start);
        }
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
    }

    private void checkOpcode(int opcode) {
        if (168 == opcode || 169 == opcode || 194 == opcode || 195 == opcode) {
            RejectedClassException.blockedOpcode(opcode);
        }
    }

    private boolean checkJclMethodExists(String owner, String name, String descriptor) {
        boolean didMatch = false;
        String mappedOwnerSlashName = Utilities.internalNameToFullyQualifiedName(this.namespaceMapper.mapType(owner, this.preserveDebuggability));
        String mappedMethodName = NamespaceMapper.mapMethodName(name);
        String mappedDescriptor = this.namespaceMapper.mapDescriptor(descriptor, this.preserveDebuggability);
        if (NodeEnvironment.singleton.shadowClassSlashNameMethodDescriptorMap.containsKey(mappedOwnerSlashName)) {
            String methodNameDescriptorString = MethodDescriptorCollector.buildMethodNameDescriptorString(mappedMethodName, mappedDescriptor);
            didMatch = NodeEnvironment.singleton.shadowClassSlashNameMethodDescriptorMap.get(mappedOwnerSlashName).contains(methodNameDescriptorString);
        }
        return didMatch;
    }
}

