/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.shadowing;

import org.aion.avm.core.util.DescriptorParser;

class IObjectReplacer {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final String AVM_INTERNAL_IOBJECT = "i/IObject";
    private final String shadowJavaLangObject;

    IObjectReplacer(String shadowPackage) {
        this.shadowJavaLangObject = shadowPackage + JAVA_LANG_OBJECT;
    }

    protected String replaceType(String type, boolean allowInterfaceReplacement) {
        boolean isTypeJavaLangObject = this.shadowJavaLangObject.equals(type);
        if (allowInterfaceReplacement && isTypeJavaLangObject) {
            return AVM_INTERNAL_IOBJECT;
        }
        return type;
    }

    String replaceMethodDescriptor(String methodDescriptor) {
        StringBuilder sb = DescriptorParser.parse(methodDescriptor, new DescriptorParser.Callbacks<StringBuilder>(){

            @Override
            public StringBuilder readObject(int arrayDimensions, String type, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('L');
                userData.append(IObjectReplacer.this.replaceType(type, true));
                userData.append(';');
                return userData;
            }

            @Override
            public StringBuilder readBoolean(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('Z');
                return userData;
            }

            @Override
            public StringBuilder readShort(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('S');
                return userData;
            }

            @Override
            public StringBuilder readLong(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('J');
                return userData;
            }

            @Override
            public StringBuilder readInteger(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('I');
                return userData;
            }

            @Override
            public StringBuilder readFloat(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('F');
                return userData;
            }

            @Override
            public StringBuilder readDouble(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('D');
                return userData;
            }

            @Override
            public StringBuilder readChar(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('C');
                return userData;
            }

            @Override
            public StringBuilder readByte(int arrayDimensions, StringBuilder userData) {
                this.populateArray(userData, arrayDimensions);
                userData.append('B');
                return userData;
            }

            @Override
            public StringBuilder argumentStart(StringBuilder userData) {
                userData.append('(');
                return userData;
            }

            @Override
            public StringBuilder argumentEnd(StringBuilder userData) {
                userData.append(')');
                return userData;
            }

            @Override
            public StringBuilder readVoid(StringBuilder userData) {
                userData.append('V');
                return userData;
            }

            private void populateArray(StringBuilder builder, int dimensions) {
                for (int i = 0; i < dimensions; ++i) {
                    builder.append('[');
                }
            }
        }, new StringBuilder());
        return sb.toString();
    }
}

