/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.stacktracking;

import i.RuntimeAssertionError;
import java.util.ArrayList;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.MethodNode;

class StackWatcherMethodAdapter
extends AdviceAdapter {
    private int stackDepthLocalVariableIndex = -1;
    private int stackSizeLocalVariableIndex = -1;
    private int maxLocals = 0;
    private int maxStack = 0;
    private int tryCatchBlockCount = 0;
    private static final int NUM_INSTRUMENTED_LOCALS = 2;
    private static final int NUM_INSTRUMENTED_STACK = 2;
    private ArrayList<Label> catchBlockList = new ArrayList();
    private Type typeInt = Type.getType(Integer.TYPE);
    private Type typeHelper = Type.getType((String)"LH;");

    public StackWatcherMethodAdapter(GeneratorAdapter mv, int access, String name, String desc) {
        super(458752, (MethodVisitor)mv, access, name, desc);
    }

    public void setMax(MethodNode node, int l, int s) {
        this.maxLocals = l;
        this.maxStack = s;
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        RuntimeAssertionError.assertTrue(maxStack == this.maxStack);
        RuntimeAssertionError.assertTrue(maxLocals == this.maxLocals);
        super.visitMaxs(maxStack + 2, maxLocals + 2);
    }

    public void setTryCatchBlockNum(int l) {
        this.tryCatchBlockCount = l;
    }

    public void visitCode() {
        super.visitCode();
        Method m1 = Method.getMethod((String)"void enterMethod(int)");
        this.visitLdcInsn(this.maxLocals + this.maxStack);
        this.invokeStatic(this.typeHelper, m1);
        if (this.tryCatchBlockCount > 0) {
            Method m2 = Method.getMethod((String)"int getCurStackDepth()");
            this.invokeStatic(this.typeHelper, m2);
            this.stackDepthLocalVariableIndex = this.newLocal(this.typeInt);
            this.storeLocal(this.stackDepthLocalVariableIndex, this.typeInt);
            Method m3 = Method.getMethod((String)"int getCurStackSize()");
            this.invokeStatic(this.typeHelper, m3);
            this.stackSizeLocalVariableIndex = this.newLocal(this.typeInt);
            this.storeLocal(this.stackSizeLocalVariableIndex, this.typeInt);
        }
    }

    protected void onMethodExit(int opcode) {
        Method m1 = Method.getMethod((String)"void exitMethod(int)");
        this.visitLdcInsn(this.maxLocals + this.maxStack);
        this.invokeStatic(this.typeHelper, m1);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.catchBlockList.add(handler);
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLabel(Label label) {
        this.mv.visitLabel(label);
        if (this.catchBlockList.contains(label)) {
            this.loadLocal(this.stackDepthLocalVariableIndex, this.typeInt);
            this.loadLocal(this.stackSizeLocalVariableIndex, this.typeInt);
            Method m1 = Method.getMethod((String)"void enterCatchBlock(int, int)");
            this.invokeStatic(this.typeHelper, m1);
        }
    }
}

