/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.CommonType;

public final class ClassInformationRenamer {
    public static ClassInformation toPostRenameClassInfo(ClassRenamer classRenamer, ClassInformation classInformation) {
        RuntimeAssertionError.assertTrue(classInformation.isPreRenameClassInfo);
        RuntimeAssertionError.assertTrue(!classInformation.dotName.equals(CommonType.JAVA_LANG_OBJECT.dotName));
        String renamedSelf = classRenamer.toPostRenameOrRejectClass(classInformation.dotName, ClassRenamer.ArrayType.NOT_ARRAY);
        String renamedParent = ClassInformationRenamer.getParentRenamed(classRenamer, classInformation);
        String[] renamedInterfaces = ClassInformationRenamer.getInterfacesRenamed(classRenamer, classInformation);
        return ClassInformation.postRenameInfoFor(classInformation.isInterface, renamedSelf, renamedParent, renamedInterfaces);
    }

    private static String getParentRenamed(ClassRenamer classRenamer, ClassInformation classInformation) {
        if (classInformation.superClassDotName == null) {
            return null;
        }
        if (classInformation.superClassDotName.equals(CommonType.JAVA_LANG_OBJECT.dotName)) {
            return classInformation.isInterface ? null : CommonType.SHADOW_OBJECT.dotName;
        }
        return classRenamer.toPostRenameOrRejectClass(classInformation.superClassDotName, ClassRenamer.ArrayType.NOT_ARRAY);
    }

    private static String[] getInterfacesRenamed(ClassRenamer classRenamer, ClassInformation classInformation) {
        String[] interfaces = classInformation.getInterfaces();
        String[] renamedInterfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            renamedInterfaces[i] = classRenamer.toPostRenameOrRejectClass(interfaces[i], ClassRenamer.ArrayType.NOT_ARRAY);
        }
        return renamedInterfaces;
    }
}

