/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;

public class Forest<I, C> {
    private final Collection<Node<I, C>> roots = new ArrayList<Node<I, C>>();
    private final Map<I, Node<I, C>> nodesIndex = new HashMap<I, Node<I, C>>();
    private Visitor<I, C> currentVisitor;
    private Node<I, C> currentVisitingRoot;

    public Collection<Node<I, C>> getRoots() {
        return Collections.unmodifiableCollection(this.roots);
    }

    public int getNodesCount() {
        return this.nodesIndex.size();
    }

    public Node<I, C> getNodeById(I id) {
        Objects.requireNonNull(id);
        return this.nodesIndex.get(id);
    }

    public Node<I, C> lookupNode(Node<I, C> target) {
        Objects.requireNonNull(target);
        return this.nodesIndex.get(target.getId());
    }

    public void add(Node<I, C> parent, Node<I, C> child) {
        Objects.requireNonNull(child);
        Objects.requireNonNull(parent);
        if (parent.getId().equals(child.getId())) {
            throw new IllegalArgumentException(String.format("parent(%s) id must not be equal to child id (%s)", parent.getId(), child.getId()));
        }
        Node<I, C> parentCandidate = this.lookupExistingFor(parent);
        if (parentCandidate == null) {
            parentCandidate = parent;
            this.roots.add(parentCandidate);
            this.nodesIndex.put(parentCandidate.getId(), parentCandidate);
        }
        Node<I, C> childCandidate = this.lookupExistingFor(child);
        boolean childExisted = true;
        if (childCandidate == null) {
            childExisted = false;
            childCandidate = child;
            this.nodesIndex.put(childCandidate.getId(), childCandidate);
        }
        if (childExisted && this.roots.contains(childCandidate)) {
            this.roots.remove(childCandidate);
        }
        parentCandidate.addChild(childCandidate);
        childCandidate.setParent(parentCandidate);
    }

    public void prune(Collection<Node<I, C>> newRoots) {
        Objects.requireNonNull(newRoots);
        Visitor pruneVisitor = new Visitor<I, C>(){

            @Override
            public void onVisitRoot(Node<I, C> root) {
                Forest.this.nodesIndex.remove(root.getId());
            }

            @Override
            public void onVisitNotRootNode(Node<I, C> node) {
                Forest.this.nodesIndex.remove(node.getId());
            }

            @Override
            public void afterAllNodesVisited() {
            }
        };
        Iterator<Node<I, C>> iterator = this.roots.iterator();
        while (iterator.hasNext()) {
            Node<I, C> root = iterator.next();
            if (newRoots.contains(root)) continue;
            this.walkOneTreePreOrder(pruneVisitor, root);
            iterator.remove();
        }
    }

    public void walkPreOrder(Visitor<I, C> visitor) {
        Objects.requireNonNull(visitor);
        this.currentVisitor = visitor;
        for (Node<I, C> root : this.roots) {
            this.currentVisitingRoot = root;
            this.walkPreOrderInternal(root);
        }
        visitor.afterAllNodesVisited();
    }

    private void walkOneTreePreOrder(Visitor<I, C> visitor, Node<I, C> root) {
        Objects.requireNonNull(visitor);
        this.currentVisitor = visitor;
        this.currentVisitingRoot = root;
        this.walkPreOrderInternal(root);
        visitor.afterAllNodesVisited();
    }

    private void walkPreOrderInternal(Node<I, C> node) {
        if (node == this.currentVisitingRoot) {
            this.currentVisitor.onVisitRoot(node);
        } else {
            this.currentVisitor.onVisitNotRootNode(node);
        }
        for (Node<I, C> child : node.getChildren()) {
            this.walkPreOrderInternal(child);
        }
    }

    private Node<I, C> lookupExistingFor(Node<I, C> node) {
        return this.nodesIndex.get(node.getId());
    }

    public static class VisitorAdapter<I, C>
    implements Visitor<I, C> {
        @Override
        public void onVisitRoot(Node<I, C> root) {
        }

        @Override
        public void onVisitNotRootNode(Node<I, C> node) {
        }

        @Override
        public void afterAllNodesVisited() {
        }
    }

    public static interface Visitor<I, C> {
        public void onVisitRoot(Node<I, C> var1);

        public void onVisitNotRootNode(Node<I, C> var1);

        public void afterAllNodesVisited();
    }

    public static class Node<I, C> {
        private final Collection<Node<I, C>> childs = new LinkedHashSet<Node<I, C>>();
        private I id;
        private C content;
        private Node<I, C> parent;

        public Node(I id, C content) {
            Objects.requireNonNull(id);
            this.id = id;
            this.content = content;
        }

        public Node<I, C> getParent() {
            return this.parent;
        }

        public void setParent(Node<I, C> parent) {
            this.parent = parent;
        }

        public void addChild(Node<I, C> child) {
            Objects.requireNonNull(child);
            this.childs.add(child);
        }

        public Collection<Node<I, C>> getChildren() {
            return Collections.unmodifiableCollection(this.childs);
        }

        public I getId() {
            return this.id;
        }

        public C getContent() {
            return this.content;
        }

        public void setContent(C c) {
            this.content = c;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object that) {
            return that instanceof Node && this.id.equals(((Node)that).id);
        }
    }
}

