/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.aion.avm.core.dappreading.LoadedJar;
import org.aion.avm.utilities.JarBuilder;

public class ImmortalDappModule {
    private static final int MAX_JAR_BYTES = 0x100000;
    private static final String APIS_NAME = "META-INF/APIS";
    public final Map<String, byte[]> classes;
    public final String mainClass;
    public final byte[] apis;

    public static ImmortalDappModule readFromJar(byte[] jar) throws IOException {
        LoadedJar loadedJar = LoadedJar.fromBytes(jar);
        Map<String, byte[]> classes = loadedJar.classBytesByQualifiedNames;
        String mainClass = loadedJar.mainClassName;
        byte[] apis = JarBuilder.getAPIsBytesFromJAR(jar);
        return null != mainClass && !classes.isEmpty() && null != apis ? new ImmortalDappModule(classes, mainClass, apis) : null;
    }

    public static ImmortalDappModule fromImmortalClasses(Map<String, byte[]> classes, String mainClass, byte[] apis) {
        return new ImmortalDappModule(classes, mainClass, apis);
    }

    private ImmortalDappModule(Map<String, byte[]> classes, String mainClass, byte[] apis) {
        this.classes = classes;
        this.mainClass = mainClass;
        this.apis = apis;
    }

    public byte[] createJar(long blockTimeStamp) throws IOException {
        FileTime timestamp = FileTime.fromMillis(blockTimeStamp / 1000L);
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.mainClass);
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        manifestEntry.setLastModifiedTime(timestamp);
        manifestEntry.setLastAccessTime(timestamp);
        manifestEntry.setCreationTime(timestamp);
        ByteArrayOutputStream tempJarStream = new ByteArrayOutputStream(0x100000);
        try (JarOutputStream target = new JarOutputStream(tempJarStream);){
            target.putNextEntry(manifestEntry);
            manifest.write(target);
            target.closeEntry();
            for (String clazz : this.classes.keySet()) {
                JarEntry entry = new JarEntry(clazz.replace('.', '/') + ".class");
                entry.setLastModifiedTime(timestamp);
                entry.setLastAccessTime(timestamp);
                entry.setCreationTime(timestamp);
                target.putNextEntry(entry);
                target.write(this.classes.get(clazz));
                target.closeEntry();
            }
            if (null != this.apis) {
                JarEntry entry = new JarEntry(APIS_NAME);
                entry.setLastModifiedTime(timestamp);
                entry.setLastAccessTime(timestamp);
                entry.setCreationTime(timestamp);
                target.putNextEntry(entry);
                target.write(this.apis);
                target.closeEntry();
            }
        }
        return tempJarStream.toByteArray();
    }
}

