/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import foundation.icon.ee.types.IllegalFormatException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aion.avm.NameStyle;
import org.aion.avm.core.ClassHierarchyForest;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.ClassRenamerBuilder;
import org.aion.avm.core.dappreading.LoadedJar;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.ClassHierarchyBuilder;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.ClassInformationFactory;
import org.aion.avm.core.types.CommonType;

public class RawDappModule {
    public final Map<String, byte[]> classes;
    public final String mainClass;
    public final ClassHierarchyForest classHierarchyForest;
    public final ClassHierarchy classHierarchy;
    public final ClassRenamer classRenamer;
    public final long bytecodeSize;
    public final long numberOfClasses;

    public static RawDappModule readFromJar(byte[] jar, boolean preserveDebuggability) throws IOException {
        LoadedJar loadedJar = LoadedJar.fromBytes(jar);
        ClassHierarchyForest forest = ClassHierarchyForest.createForestFrom(loadedJar);
        ClassInformationFactory classInfoFactory = new ClassInformationFactory();
        Set<ClassInformation> classInfos = classInfoFactory.fromUserDefinedPreRenameJar(loadedJar);
        ClassRenamer classRenamer = new ClassRenamerBuilder(NameStyle.DOT_NAME, preserveDebuggability).loadPreRenameUserDefinedClasses(RawDappModule.extractClassNames(classInfos)).loadPostRenameJclExceptionClasses(RawDappModule.fetchPostRenameJclExceptions()).build();
        ClassHierarchy fullHierarchy = new ClassHierarchyBuilder().addShadowJcl().addPreRenameUserDefinedClasses(classRenamer, classInfos).addHandwrittenArrayWrappers().addPostRenameJclExceptions().build();
        Map<String, byte[]> classes = loadedJar.classBytesByQualifiedNames;
        String mainClass = loadedJar.mainClassName;
        if (null != mainClass && !classes.isEmpty()) {
            return new RawDappModule(classes, mainClass, forest, jar.length, classes.size(), fullHierarchy, classRenamer);
        }
        throw new IllegalFormatException("bad jar");
    }

    private static Set<String> extractClassNames(Set<ClassInformation> classInformations) {
        HashSet<String> classNames = new HashSet<String>();
        for (ClassInformation classInformation : classInformations) {
            classNames.add(classInformation.dotName);
        }
        return classNames;
    }

    private static Set<String> fetchPostRenameJclExceptions() {
        HashSet<String> exceptions = new HashSet<String>();
        for (CommonType type : CommonType.values()) {
            if (!type.isShadowException) continue;
            exceptions.add(type.dotName);
        }
        return exceptions;
    }

    private RawDappModule(Map<String, byte[]> classes, String mainClass, ClassHierarchyForest classHierarchyForest, long bytecodeSize, long numberOfClasses, ClassHierarchy hierarchy, ClassRenamer classRenamer) {
        this.classes = classes;
        this.mainClass = mainClass;
        this.classHierarchyForest = classHierarchyForest;
        this.bytecodeSize = bytecodeSize;
        this.numberOfClasses = numberOfClasses;
        this.classHierarchy = hierarchy;
        this.classRenamer = classRenamer;
    }
}

