/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aion.avm.ArrayClassNameMapper;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.util.MethodDescriptorCollector;
import org.aion.avm.utilities.Utilities;

public class AllowlistProvider {
    public static Map<Class<?>, List<MethodDescriptor>> getClassLibraryMap() throws ClassNotFoundException {
        HashMap classDeclaredMethodMap = new HashMap();
        List<Class<?>> shadowClasses = AllowlistProvider.getCallableShadowClasses();
        for (Class<?> c : shadowClasses) {
            String associatedJclName = AllowlistProvider.mapClassName(c.getName());
            Class<?> jclClass = Class.forName(associatedJclName);
            List declaredMethodList = Stream.of(c.getMethods(), c.getDeclaredConstructors()).flatMap(Stream::of).filter(method -> AllowlistProvider.isSupportedExecutable(method) && AllowlistProvider.hasValidParamTypes(method)).map(AllowlistProvider::generateMethodDescriptor).sorted(Comparator.comparing(m -> m.parameters)).distinct().collect(Collectors.toList());
            classDeclaredMethodMap.put(jclClass, declaredMethodList);
        }
        return classDeclaredMethodMap;
    }

    private static List<Class<?>> getCallableShadowClasses() throws ClassNotFoundException {
        ArrayList shadowClasses = new ArrayList();
        List<String> jclClassNames = NodeEnvironment.singleton.getJclSlashClassNames();
        jclClassNames.removeAll(MethodDescriptorCollector.getOmittedClassNames());
        jclClassNames.removeAll(Arrays.asList("score/RevertedException", "score/UserRevertedException"));
        jclClassNames.replaceAll(s -> "s/" + s);
        for (String className : jclClassNames) {
            shadowClasses.add(NodeEnvironment.singleton.loadSharedClass(Utilities.internalNameToFullyQualifiedName(className)));
        }
        return shadowClasses;
    }

    private static String mapClassName(String className) {
        if (AllowlistProvider.isShadowClass(className)) {
            return className.substring("s.".length());
        }
        if (AllowlistProvider.isArrayWrapperClass(className)) {
            return ArrayClassNameMapper.getOriginalNameFromWrapper(Utilities.fullyQualifiedNameToInternalName(className));
        }
        if (AllowlistProvider.isSupportedInternalType(className)) {
            return "java.lang.Object";
        }
        return className;
    }

    private static boolean hasValidParamTypes(Executable method) {
        for (Class<?> c : method.getParameterTypes()) {
            if (AllowlistProvider.isShadowClass(c.getName()) || AllowlistProvider.isArrayWrapperClass(c.getName()) || AllowlistProvider.isPrimitive(c) || AllowlistProvider.isSupportedInternalType(c.getName())) continue;
            if (method instanceof Method) {
                throw new AssertionError((Object)("Transformed method " + method.getDeclaringClass() + "." + method.getName() + " should not have an unsupported parameter type: " + c.getName()));
            }
            return false;
        }
        return true;
    }

    private static boolean isShadowClass(String className) {
        return className.startsWith("s.");
    }

    private static boolean isArrayWrapperClass(String className) {
        return className.startsWith("a.");
    }

    private static boolean isSupportedInternalType(String className) {
        return className.equals("i.IObject") || className.equals("i.IObjectArray");
    }

    private static boolean isSupportedExecutable(Executable method) {
        if (method instanceof Constructor) {
            return Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers());
        }
        return method.getName().startsWith("avm_");
    }

    private static boolean isPrimitive(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive();
    }

    private static MethodDescriptor generateMethodDescriptor(Executable method) {
        String methodName = AllowlistProvider.mapMethodName(method);
        String descriptorString = AllowlistProvider.buildDescriptorString(method);
        return new MethodDescriptor(methodName, descriptorString, Modifier.isStatic(method.getModifiers()));
    }

    private static String mapMethodName(Executable method) {
        if (method instanceof Constructor) {
            if (Modifier.isStatic(method.getModifiers())) {
                throw new AssertionError((Object)"Static constructor should not exist.");
            }
            return "<init>";
        }
        return method.getName().substring("avm_".length());
    }

    private static String buildDescriptorString(Executable method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Class<?> param : parameterTypes) {
            AllowlistProvider.writeClass(builder, param, method);
        }
        builder.append(')');
        if (method instanceof Method) {
            AllowlistProvider.writeClass(builder, ((Method)method).getReturnType(), method);
        } else {
            builder.append("V");
        }
        return builder.toString();
    }

    private static void writeClass(StringBuilder builder, Class<?> clazz, Executable method) {
        if (clazz.isArray()) {
            builder.append('[');
            AllowlistProvider.writeClass(builder, clazz.getComponentType(), method);
        } else if (!clazz.isPrimitive()) {
            String className = clazz.getName();
            if (AllowlistProvider.isArrayWrapperClass(className)) {
                builder.append(ArrayClassNameMapper.getOriginalNameFromWrapper(Utilities.fullyQualifiedNameToInternalName(className)));
            } else {
                String mappedClassName = AllowlistProvider.mapClassName(className);
                if ("i.IObjectArray".equals(className)) {
                    builder.append('[');
                    if ("s.java.util.Map".equals(method.getDeclaringClass().getName()) && "avm_ofEntries".equals(method.getName())) {
                        mappedClassName = "java.util.Map$Entry";
                    }
                }
                builder.append('L');
                builder.append(Utilities.fullyQualifiedNameToInternalName(mappedClassName));
                builder.append(';');
            }
        } else if (Byte.TYPE == clazz) {
            builder.append('B');
        } else if (Character.TYPE == clazz) {
            builder.append('C');
        } else if (Double.TYPE == clazz) {
            builder.append('D');
        } else if (Float.TYPE == clazz) {
            builder.append('F');
        } else if (Integer.TYPE == clazz) {
            builder.append('I');
        } else if (Long.TYPE == clazz) {
            builder.append('J');
        } else if (Short.TYPE == clazz) {
            builder.append('S');
        } else if (Boolean.TYPE == clazz) {
            builder.append('Z');
        } else if (Void.TYPE == clazz) {
            builder.append('V');
        } else {
            throw new AssertionError((Object)("Missing descriptor type: " + clazz));
        }
    }

    public static class MethodDescriptor {
        public final String name;
        public final String parameters;
        public final boolean isStatic;

        public MethodDescriptor(String name, String parameters, boolean isStatic) {
            this.name = name;
            this.parameters = parameters;
            this.isStatic = isStatic;
        }

        public String toString() {
            return "MethodDescriptor{name='" + this.name + "', parameters=" + this.parameters + ", isStatic=" + this.isStatic + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDescriptor that = (MethodDescriptor)o;
            return this.isStatic == that.isStatic && this.name.equals(that.name) && this.parameters.equals(that.parameters);
        }

        public int hashCode() {
            int result = Objects.hash(this.name, this.isStatic);
            result = 31 * result + this.parameters.hashCode();
            return result;
        }
    }
}

