/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Utilities {
    private static final int MAX_CLASS_BYTES = 0x100000;

    public static String fullyQualifiedNameToInternalName(String fullyQualifiedName) {
        return fullyQualifiedName.replaceAll("\\.", "/");
    }

    public static String internalNameToFullyQualifiedName(String internalName) {
        return internalName.replaceAll("/", ".");
    }

    public static byte[] loadRequiredResourceAsBytes(String resourcePath) {
        InputStream stream = Utilities.class.getClassLoader().getResourceAsStream(resourcePath);
        byte[] raw = null;
        if (null != stream) {
            try {
                raw = stream.readAllBytes();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return raw;
    }

    public static Map<String, byte[]> extractClasses(JarInputStream jarReader, NameStyle nameStyle) throws IOException {
        JarEntry entry;
        HashMap<String, byte[]> classMap = new HashMap<String, byte[]>();
        byte[] tempReadingBuffer = new byte[0x100000];
        while (null != (entry = jarReader.getNextJarEntry())) {
            String name = entry.getName();
            if (!name.endsWith(".class") || name.equals("package-info.class") || name.equals("module-info.class")) continue;
            String internalClassName = name.replaceAll(".class$", "");
            if (nameStyle.equals((Object)NameStyle.DOT_NAME)) {
                internalClassName = Utilities.internalNameToFullyQualifiedName(internalClassName);
            }
            int readSize = jarReader.readNBytes(tempReadingBuffer, 0, tempReadingBuffer.length);
            if (0 != jarReader.available()) {
                throw new RuntimeException("Class file too big: " + name);
            }
            byte[] classBytes = new byte[readSize];
            System.arraycopy(tempReadingBuffer, 0, classBytes, 0, readSize);
            classMap.put(internalClassName, classBytes);
        }
        return classMap;
    }

    public static String extractMainClassName(JarInputStream jarReader, NameStyle nameStyle) {
        Manifest manifest = jarReader.getManifest();
        if (null != manifest && manifest.getMainAttributes() != null) {
            String mainClassName = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (nameStyle.equals((Object)NameStyle.SLASH_NAME)) {
                mainClassName = Utilities.fullyQualifiedNameToInternalName(mainClassName);
            }
            return mainClassName;
        }
        throw new RuntimeException("Manifest file required");
    }

    public static enum NameStyle {
        DOT_NAME,
        SLASH_NAME;

    }
}

