/*
 * Decompiled with CFR 0.152.
 */
package org.aion.parallel;

import foundation.icon.ee.types.Address;
import foundation.icon.ee.types.Transaction;
import i.IInstrumentation;
import i.RuntimeAssertionError;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.ReentrantDAppStack;

public class TransactionTask {
    private final IExternalState parentKernel;
    private Transaction externalTransaction;
    private IInstrumentation threadOwningTask;
    private ReentrantDAppStack reentrantDAppStack;
    private Address origin;
    private int depth;
    private int eid;
    private int prevEID;

    public TransactionTask(IExternalState parentKernel, Transaction tx, Address origin) {
        this.parentKernel = parentKernel;
        this.externalTransaction = tx;
        this.threadOwningTask = null;
        this.reentrantDAppStack = new ReentrantDAppStack();
        this.origin = origin;
        this.depth = 0;
    }

    public void startNewTransaction() {
        this.threadOwningTask = null;
        this.reentrantDAppStack = new ReentrantDAppStack();
    }

    public void attachInstrumentationForThread() {
        RuntimeAssertionError.assertTrue(null == this.threadOwningTask);
        this.threadOwningTask = IInstrumentation.attachedThreadInstrumentation.get();
        RuntimeAssertionError.assertTrue(null != this.threadOwningTask);
    }

    public void detachInstrumentationForThread() {
        RuntimeAssertionError.assertTrue(IInstrumentation.attachedThreadInstrumentation.get() == this.threadOwningTask);
        this.threadOwningTask = null;
    }

    public ReentrantDAppStack getReentrantDAppStack() {
        return this.reentrantDAppStack;
    }

    public Transaction getTransaction() {
        return this.externalTransaction;
    }

    public IExternalState getThisTransactionalKernel() {
        return this.parentKernel;
    }

    public Address getOriginAddress() {
        return this.origin;
    }

    public int getTransactionStackDepth() {
        return this.depth;
    }

    public void incrementTransactionStackDepth() {
        ++this.depth;
    }

    public void decrementTransactionStackDepth() {
        --this.depth;
    }

    public int getEID() {
        return this.eid;
    }

    public void setEID(int eid) {
        this.eid = eid;
    }

    public int getPrevEID() {
        return this.prevEID;
    }

    public void setPrevEID(int prevEID) {
        this.prevEID = prevEID;
    }
}

