/*
 * Decompiled with CFR 0.152.
 */
package pi;

import foundation.icon.ee.util.Crypto;
import foundation.icon.ee.util.ValueCodec;
import i.CodecIdioms;
import i.IDBStorage;
import i.IInstrumentation;
import i.IObject;
import i.IObjectDeserializer;
import i.IObjectSerializer;
import i.RLPCoder;
import p.score.AnyDB;
import s.java.lang.Class;
import s.java.lang.Object;
import s.java.lang.String;

public class AnyDBImpl
extends Object
implements AnyDB {
    private static final byte TYPE_ARRAY_DB = 0;
    private static final byte TYPE_DICT_DB = 1;
    private static final byte TYPE_VAR_DB = 2;
    private Class<?> leafValue;
    private byte[] prefix;
    private byte[] hash;

    public AnyDBImpl(String id, Class<?> vc) {
        this(AnyDBImpl.catEncodedKey(new byte[]{0}, id), vc);
    }

    private AnyDBImpl(byte[] prefix, Class<?> vc) {
        this.prefix = prefix;
        this.leafValue = vc;
    }

    public AnyDBImpl(Void ignore, int readIndex) {
        super(ignore, readIndex);
    }

    private static byte[] catEncodedKey(byte[] prefix, java.lang.Object k) {
        RLPCoder c = new RLPCoder();
        c.write(prefix);
        c.encode(k);
        return c.toByteArray();
    }

    private static byte[] catEncodedKey(byte[] prefix, int k) {
        RLPCoder c = new RLPCoder();
        c.write(prefix);
        c.encode(k);
        return c.toByteArray();
    }

    private IDBStorage getDBStorage() {
        return IInstrumentation.getCurrentFrameContext().getDBStorage();
    }

    private byte[] hashWithCharge(byte[] data) {
        IInstrumentation.charge(100 + 50 * (data != null ? data.length : 0));
        return Crypto.sha3_256(data);
    }

    private byte[] getStorageKey(byte type) {
        IInstrumentation.charge(100 + 50 * this.prefix.length);
        if (this.hash == null) {
            this.prefix[0] = type;
            this.hash = Crypto.sha3_256(this.prefix);
        }
        return this.hash;
    }

    private byte[] getItemStorageKey(IObject key) {
        this.prefix[0] = 1;
        return this.hashWithCharge(AnyDBImpl.catEncodedKey(this.prefix, key));
    }

    private byte[] getItemStorageKey(int key) {
        this.prefix[0] = 0;
        return this.hashWithCharge(AnyDBImpl.catEncodedKey(this.prefix, key));
    }

    private byte[] getSubDBID(IObject key) {
        return AnyDBImpl.catEncodedKey(this.prefix, key);
    }

    private byte[] encode(IObject obj) {
        return ValueCodec.encode(obj);
    }

    private IObject decode(byte[] raw) {
        return ValueCodec.decode(raw, this.leafValue);
    }

    @Override
    public void deserializeSelf(java.lang.Class<?> firstRealImplementation, IObjectDeserializer deserializer) {
        super.deserializeSelf(AnyDBImpl.class, deserializer);
        this.prefix = CodecIdioms.deserializeByteArray(deserializer);
        this.leafValue = (Class)deserializer.readObject();
    }

    @Override
    public void serializeSelf(java.lang.Class<?> firstRealImplementation, IObjectSerializer serializer) {
        super.serializeSelf(AnyDBImpl.class, serializer);
        this.prefix[0] = 0;
        CodecIdioms.serializeByteArray(serializer, this.prefix);
        serializer.writeObject(this.leafValue);
    }

    @Override
    public void avm_set(IObject value) {
        this.getDBStorage().setBytes(this.getStorageKey((byte)2), this.encode(value));
    }

    @Override
    public IObject avm_get() {
        return this.decode(this.getDBStorage().getBytes(this.getStorageKey((byte)2)));
    }

    @Override
    public IObject avm_getOrDefault(IObject defaultValue) {
        IObject out = this.decode(this.getDBStorage().getBytes(this.getStorageKey((byte)2)));
        return out != null ? out : defaultValue;
    }

    @Override
    public IObject avm_at(IObject key) {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergy(100);
        return new AnyDBImpl(this.getSubDBID(key), this.leafValue);
    }

    @Override
    public void avm_set(IObject key, IObject value) {
        this.getDBStorage().setBytes(this.getItemStorageKey(key), this.encode(value));
    }

    @Override
    public IObject avm_get(IObject key) {
        return this.decode(this.getDBStorage().getBytes(this.getItemStorageKey(key)));
    }

    @Override
    public IObject avm_getOrDefault(IObject key, IObject defaultValue) {
        IObject out = this.decode(this.getDBStorage().getBytes(this.getItemStorageKey(key)));
        return out != null ? out : defaultValue;
    }

    @Override
    public void avm_add(IObject value) {
        IDBStorage s = this.getDBStorage();
        int sz = s.getArrayLength(this.getStorageKey((byte)0));
        s.setBytes(this.getItemStorageKey(sz), this.encode(value));
        s.setArrayLength(this.getStorageKey((byte)0), sz + 1);
    }

    @Override
    public void avm_set(int index, IObject value) {
        IDBStorage s = this.getDBStorage();
        int sz = s.getArrayLength(this.getStorageKey((byte)0));
        if (index >= sz || index < 0) {
            throw new IllegalArgumentException();
        }
        s.setBytes(this.getItemStorageKey(index), this.encode(value));
    }

    @Override
    public void avm_removeLast() {
        IDBStorage s = this.getDBStorage();
        int sz = s.getArrayLength(this.getStorageKey((byte)0));
        if (sz <= 0) {
            throw new IllegalStateException();
        }
        s.setBytes(this.getItemStorageKey(sz - 1), null);
        s.setArrayLength(this.getStorageKey((byte)0), sz - 1);
    }

    @Override
    public IObject avm_pop() {
        IDBStorage s = this.getDBStorage();
        int sz = s.getArrayLength(this.getStorageKey((byte)0));
        if (sz <= 0) {
            throw new IllegalStateException();
        }
        IObject o = this.decode(s.getBytes(this.getItemStorageKey(sz - 1)));
        s.setBytes(this.getItemStorageKey(sz - 1), null);
        s.setArrayLength(this.getStorageKey((byte)0), sz - 1);
        return o;
    }

    @Override
    public IObject avm_get(int index) {
        IDBStorage s = this.getDBStorage();
        int sz = s.getArrayLength(this.getStorageKey((byte)0));
        if (index >= sz || index < 0) {
            throw new IllegalArgumentException();
        }
        return this.decode(s.getBytes(this.getItemStorageKey(index)));
    }

    @Override
    public int avm_size() {
        return this.getDBStorage().getArrayLength(this.getStorageKey((byte)0));
    }
}

