/*
 * Decompiled with CFR 0.152.
 */
package hu.ssh.progressbar;

import hu.ssh.progressbar.Progress;
import hu.ssh.progressbar.ProgressBar;

public abstract class AbstractProgressBar<T extends AbstractProgressBar<?>>
implements ProgressBar<T> {
    protected final long totalSteps;
    private long actualSteps = 0L;
    private long startTime = 0L;
    private long lastUpdate = 0L;
    private int lastUpdatePercent = 0;

    protected AbstractProgressBar(long totalSteps) {
        this.totalSteps = totalSteps;
    }

    @Override
    public final void start() {
        this.refresh();
    }

    @Override
    public final void tickOne() {
        this.tick(1L);
    }

    @Override
    public final void tick(long steps) {
        this.setStartTimeIfNotStarted();
        this.actualSteps += steps;
        if (this.isRefreshNeeded()) {
            this.refresh();
        }
    }

    @Override
    public final void refresh() {
        this.setStartTimeIfNotStarted();
        Progress progress = this.getProgress();
        this.lastUpdate = System.currentTimeMillis() / 1000L;
        this.lastUpdatePercent = (int)(progress.getPercentage() * 100.0f);
        this.updateProgressBar(progress);
    }

    @Override
    public final void complete() {
        this.setStartTimeIfNotStarted();
        this.actualSteps = this.totalSteps;
        this.refresh();
    }

    private Progress getProgress() {
        return new Progress(this.totalSteps, this.actualSteps, System.currentTimeMillis() - this.startTime);
    }

    private void setStartTimeIfNotStarted() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    private boolean isRefreshNeeded() {
        if (this.lastUpdate != System.currentTimeMillis() / 1000L) {
            return true;
        }
        return this.lastUpdatePercent != (int)(this.actualSteps * 100L / this.totalSteps);
    }

    protected abstract void updateProgressBar(Progress var1);

    protected abstract void finishProgressBar();
}

