/*
 * Decompiled with CFR 0.152.
 */
package hu.ssh.progressbar;

public class Progress {
    private static final int MINIMAL_ELAPSED = 100;
    private final long totalSteps;
    private final long actualSteps;
    private final long elapsedTime;

    public Progress(long totalSteps, long actualSteps, long elapsedTime) {
        this.totalSteps = totalSteps;
        this.actualSteps = actualSteps;
        this.elapsedTime = elapsedTime;
    }

    public final long getTotalSteps() {
        return this.totalSteps;
    }

    public final long getActualSteps() {
        return this.actualSteps;
    }

    public final long getElapsedTime() {
        return this.elapsedTime;
    }

    public final float getPercentage() {
        return (float)this.actualSteps / (float)this.totalSteps;
    }

    public final long getRemainingTime() {
        return this.getTotalTime() - this.elapsedTime;
    }

    public final long getTotalTime() {
        return (long)((float)this.elapsedTime / this.getPercentage());
    }

    public final boolean isRemainingTimeReliable() {
        return this.elapsedTime > 100L;
    }
}

