/*
 * Decompiled with CFR 0.152.
 */
package hu.ssh.progressbar.console;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import hu.ssh.progressbar.AbstractProgressBar;
import hu.ssh.progressbar.Progress;
import hu.ssh.progressbar.console.replacers.BarReplacer;
import hu.ssh.progressbar.console.replacers.ElapsedTimeReplacer;
import hu.ssh.progressbar.console.replacers.PercentageReplacer;
import hu.ssh.progressbar.console.replacers.RemainingTimeReplacer;
import hu.ssh.progressbar.console.replacers.Replacer;
import hu.ssh.progressbar.console.replacers.TotalTimeReplacer;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Set;

public final class ConsoleProgressBar
extends AbstractProgressBar<ConsoleProgressBar> {
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final long DEFAULT_STEPS = 100L;
    public static final String DEFAULT_FORMAT = "[:bar] :percent% :eta";
    public static final int DEFAULT_PROGRESSBAR_WIDTH = 60;
    private static final Set<Replacer> DEFAULT_REPLACERS = ConsoleProgressBar.getDefaultReplacers(60);
    private final Set<Replacer> replacers;
    private final PrintStream streamToUse;
    private final String outputFormat;
    private int previousLength = 0;

    private ConsoleProgressBar(PrintStream streamToUse, long totalSteps, String progressBarFormat, Set<Replacer> replacers) {
        super(totalSteps);
        this.replacers = replacers;
        this.streamToUse = streamToUse;
        this.outputFormat = progressBarFormat;
    }

    public static ConsoleProgressBar on(PrintStream streamToUse) {
        Preconditions.checkNotNull((Object)streamToUse);
        return new ConsoleProgressBar(streamToUse, 100L, DEFAULT_FORMAT, DEFAULT_REPLACERS);
    }

    public ConsoleProgressBar withFormat(String outputFormat) {
        Preconditions.checkNotNull((Object)outputFormat);
        return new ConsoleProgressBar(this.streamToUse, this.totalSteps, outputFormat, this.replacers);
    }

    @Override
    public ConsoleProgressBar withTotalSteps(int totalSteps) {
        Preconditions.checkArgument((totalSteps != 0 ? 1 : 0) != 0);
        return new ConsoleProgressBar(this.streamToUse, totalSteps, this.outputFormat, this.replacers);
    }

    public ConsoleProgressBar withReplacers(Collection<Replacer> replacers) {
        Preconditions.checkNotNull(replacers);
        return new ConsoleProgressBar(this.streamToUse, this.totalSteps, this.outputFormat, (Set<Replacer>)ImmutableSet.copyOf(replacers));
    }

    public static Set<Replacer> getDefaultReplacers(int progressBarWidth) {
        return ImmutableSet.of((Object)new BarReplacer(progressBarWidth), (Object)new PercentageReplacer(), (Object)new RemainingTimeReplacer(), (Object)new ElapsedTimeReplacer(), (Object)new TotalTimeReplacer());
    }

    @Override
    protected void updateProgressBar(Progress progress) {
        String actualBar = this.getActualProgressBar(progress);
        this.streamToUse.print(actualBar);
        this.streamToUse.print(this.getGarbageCleaning(actualBar.length()));
        this.streamToUse.print('\r');
    }

    @Override
    protected void finishProgressBar() {
        this.streamToUse.print('\n');
    }

    private String getActualProgressBar(Progress progress) {
        String bar = this.outputFormat;
        for (Replacer replacer : this.replacers) {
            String identifier = replacer.getReplaceIdentifier();
            if (!bar.contains(identifier)) continue;
            bar = bar.replace(identifier, replacer.getReplacementForProgress(progress));
        }
        return bar;
    }

    private String getGarbageCleaning(int actualLength) {
        if (actualLength >= this.previousLength) {
            return "";
        }
        String garbageCleaner = Strings.repeat((String)" ", (int)(this.previousLength - actualLength));
        this.previousLength = actualLength;
        return garbageCleaner;
    }
}

