/*
 * Decompiled with CFR 0.152.
 */
package hu.ssh.progressbar.console.replacers;

import com.google.common.base.Strings;
import hu.ssh.progressbar.Progress;
import hu.ssh.progressbar.console.replacers.Replacer;

public class BarReplacer
implements Replacer {
    private static final String IDENTIFIER = ":bar";
    private static final String COMPLETED_CHAR = "=";
    private static final char REMAINING_CHAR = '-';
    private final int totalWidth;

    public BarReplacer(int totalWidth) {
        this.totalWidth = totalWidth;
    }

    @Override
    public final String getReplaceIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public final String getReplacementForProgress(Progress progress) {
        int actualWidth = (int)(progress.getPercentage() * (float)this.totalWidth);
        String bar = Strings.repeat((String)COMPLETED_CHAR, (int)actualWidth);
        return Strings.padEnd((String)bar, (int)this.totalWidth, (char)'-');
    }
}

