/*
 * Decompiled with CFR 0.152.
 */
package hu.ssh.progressbar.helpers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import hu.ssh.progressbar.helpers.Helper;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HumanTimeFormatter
extends Helper {
    private static final List<DisplayUnit> DISPLAY_UNITS = ImmutableList.of((Object)DisplayUnit.of(TimeUnit.DAYS, "d"), (Object)DisplayUnit.of(TimeUnit.HOURS, "h"), (Object)DisplayUnit.of(TimeUnit.MINUTES, "m"), (Object)DisplayUnit.of(TimeUnit.SECONDS, "s"), (Object)DisplayUnit.of(TimeUnit.MILLISECONDS, "ms"));

    public static String formatTime(long milliseconds) {
        long diff = milliseconds;
        StringBuilder sb = new StringBuilder();
        Iterator<DisplayUnit> iterator = DISPLAY_UNITS.iterator();
        while (iterator.hasNext()) {
            DisplayUnit displayUnit = iterator.next();
            long value = displayUnit.getFromMilliseconds(diff);
            if (value == 0L && (iterator.hasNext() || sb.length() != 0)) continue;
            sb.append(displayUnit.getWithSuffix(value));
            diff -= displayUnit.getInMilliseconds(value);
        }
        return sb.toString();
    }

    private static final class DisplayUnit {
        private final TimeUnit timeUnit;
        private final String suffix;

        private DisplayUnit(TimeUnit timeUnit, String suffix) {
            this.timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)timeUnit)));
            this.suffix = (String)Preconditions.checkNotNull((Object)suffix);
        }

        public static DisplayUnit of(TimeUnit timeUnit, String suffix) {
            return new DisplayUnit(timeUnit, suffix);
        }

        public long getFromMilliseconds(long milliseconds) {
            return this.timeUnit.convert(milliseconds, TimeUnit.MILLISECONDS);
        }

        public long getInMilliseconds(long value) {
            return TimeUnit.MILLISECONDS.convert(value, this.timeUnit);
        }

        public String getWithSuffix(long value) {
            return String.format("%d%s", value, this.suffix);
        }
    }
}

