/*
 * Decompiled with CFR 0.152.
 */
package in.erail.amazon.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import in.erail.amazon.lambda.MessageAWSLambda;
import in.erail.glue.Glue;
import in.erail.service.RESTService;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AWSLambda
implements RequestStreamHandler {
    private static final String SERVICE_ENV = "SERVICE";
    private static final String SERVICE_SYS_PROP = "service";
    private final RESTService mService;

    public AWSLambda() {
        String component = System.getenv(SERVICE_ENV);
        if (Strings.isNullOrEmpty((String)component)) {
            component = System.getProperty(SERVICE_SYS_PROP);
        }
        this.mService = (RESTService)Glue.instance().resolve(component);
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        JsonObject requestJson = new JsonObject(Buffer.buffer((byte[])ByteStreams.toByteArray((InputStream)inputStream)));
        JsonObject responseJson = this.handleMessage(requestJson);
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");){
            writer.write(responseJson.toString());
        }
    }

    public JsonObject handleMessage(JsonObject pJsonObject) {
        JsonObject msg;
        try {
            CompletableFuture result = new CompletableFuture();
            MessageAWSLambda<JsonObject> message = new MessageAWSLambda<JsonObject>(result, pJsonObject);
            Single.just(message).map(m -> new io.vertx.reactivex.core.eventbus.Message((Message)message)).subscribeOn(Schedulers.computation()).subscribe(m -> this.getService().process(m));
            msg = (JsonObject)result.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            msg = new JsonObject();
            Logger.getLogger(AWSLambda.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.transform(msg);
    }

    public JsonObject transform(JsonObject pMsg) {
        if (!pMsg.containsKey("isBase64Encoded")) {
            pMsg.put("isBase64Encoded", Boolean.FALSE);
        }
        if (!pMsg.containsKey("statusCode")) {
            pMsg.put("statusCode", "200");
        }
        if (!pMsg.containsKey("headers")) {
            pMsg.put("headers", new JsonObject());
        }
        if (!pMsg.containsKey("body")) {
            pMsg.put("body", new JsonObject().toString());
        } else {
            String body = pMsg.getValue("body").toString();
            pMsg.put("body", body);
        }
        return pMsg;
    }

    public RESTService getService() {
        return this.mService;
    }
}

