package io.alauda.devops.java.client.extend.controller;

import io.kubernetes.client.informer.ResourceEventHandler;

public interface ControllerWatch<ApiType> {
    /**
     * Gets the watching resource class.
     *
     * @return the resouce class
     */
    Class<ApiType> getResourceClass();

    /**
     * Gets the event handler on watch events from the resource.
     *
     * @return the resource event handler
     */
    ResourceEventHandler<ApiType> getResourceEventHandler();
}