package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoBindingTemplateBuilder extends V1alpha1CodeRepoBindingTemplateFluentImpl<V1alpha1CodeRepoBindingTemplateBuilder> implements VisitableBuilder<V1alpha1CodeRepoBindingTemplate,V1alpha1CodeRepoBindingTemplateBuilder>{

    V1alpha1CodeRepoBindingTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoBindingTemplateBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoBindingTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoBindingTemplate(), validationEnabled);
    }
    public V1alpha1CodeRepoBindingTemplateBuilder(V1alpha1CodeRepoBindingTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoBindingTemplateBuilder(V1alpha1CodeRepoBindingTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoBindingTemplate(), validationEnabled);
    }
    public V1alpha1CodeRepoBindingTemplateBuilder(V1alpha1CodeRepoBindingTemplateFluent<?> fluent,V1alpha1CodeRepoBindingTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoBindingTemplateBuilder(V1alpha1CodeRepoBindingTemplateFluent<?> fluent,V1alpha1CodeRepoBindingTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoBindingTemplateBuilder(V1alpha1CodeRepoBindingTemplate instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoBindingTemplateBuilder(V1alpha1CodeRepoBindingTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoBindingTemplate build(){
            V1alpha1CodeRepoBindingTemplate buildable = new V1alpha1CodeRepoBindingTemplate();
            buildable.setSelector(fluent.getSelector());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBindingTemplateBuilder that = (V1alpha1CodeRepoBindingTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
