package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoServiceAuthorizeCreateBuilder extends V1alpha1CodeRepoServiceAuthorizeCreateFluentImpl<V1alpha1CodeRepoServiceAuthorizeCreateBuilder> implements VisitableBuilder<V1alpha1CodeRepoServiceAuthorizeCreate,V1alpha1CodeRepoServiceAuthorizeCreateBuilder>{

    V1alpha1CodeRepoServiceAuthorizeCreateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoServiceAuthorizeCreate(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(V1alpha1CodeRepoServiceAuthorizeCreateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(V1alpha1CodeRepoServiceAuthorizeCreateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoServiceAuthorizeCreate(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(V1alpha1CodeRepoServiceAuthorizeCreateFluent<?> fluent,V1alpha1CodeRepoServiceAuthorizeCreate instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(V1alpha1CodeRepoServiceAuthorizeCreateFluent<?> fluent,V1alpha1CodeRepoServiceAuthorizeCreate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCode(instance.getCode());

            fluent.withGetAccessToken(instance.isGetAccessToken());

            fluent.withNamespace(instance.getNamespace());

            fluent.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(V1alpha1CodeRepoServiceAuthorizeCreate instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoServiceAuthorizeCreateBuilder(V1alpha1CodeRepoServiceAuthorizeCreate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCode(instance.getCode());

            this.withGetAccessToken(instance.isGetAccessToken());

            this.withNamespace(instance.getNamespace());

            this.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoServiceAuthorizeCreate build(){
            V1alpha1CodeRepoServiceAuthorizeCreate buildable = new V1alpha1CodeRepoServiceAuthorizeCreate();
            buildable.setCode(fluent.getCode());
            buildable.setGetAccessToken(fluent.isGetAccessToken());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setSecretName(fluent.getSecretName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoServiceAuthorizeCreateBuilder that = (V1alpha1CodeRepoServiceAuthorizeCreateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
