package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryOwnerBuilder extends V1alpha1CodeRepositoryOwnerFluentImpl<V1alpha1CodeRepositoryOwnerBuilder> implements VisitableBuilder<V1alpha1CodeRepositoryOwner,V1alpha1CodeRepositoryOwnerBuilder>{

    V1alpha1CodeRepositoryOwnerFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositoryOwnerBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositoryOwnerBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepositoryOwner(), validationEnabled);
    }
    public V1alpha1CodeRepositoryOwnerBuilder(V1alpha1CodeRepositoryOwnerFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositoryOwnerBuilder(V1alpha1CodeRepositoryOwnerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepositoryOwner(), validationEnabled);
    }
    public V1alpha1CodeRepositoryOwnerBuilder(V1alpha1CodeRepositoryOwnerFluent<?> fluent,V1alpha1CodeRepositoryOwner instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositoryOwnerBuilder(V1alpha1CodeRepositoryOwnerFluent<?> fluent,V1alpha1CodeRepositoryOwner instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvatarURL(instance.getAvatarURL());

            fluent.withDiskUsage(instance.getDiskUsage());

            fluent.withEmail(instance.getEmail());

            fluent.withHtmlURL(instance.getHtmlURL());

            fluent.withId(instance.getId());

            fluent.withName(instance.getName());

            fluent.withRepositories(instance.getRepositories());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositoryOwnerBuilder(V1alpha1CodeRepositoryOwner instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositoryOwnerBuilder(V1alpha1CodeRepositoryOwner instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvatarURL(instance.getAvatarURL());

            this.withDiskUsage(instance.getDiskUsage());

            this.withEmail(instance.getEmail());

            this.withHtmlURL(instance.getHtmlURL());

            this.withId(instance.getId());

            this.withName(instance.getName());

            this.withRepositories(instance.getRepositories());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepositoryOwner build(){
            V1alpha1CodeRepositoryOwner buildable = new V1alpha1CodeRepositoryOwner();
            buildable.setAvatarURL(fluent.getAvatarURL());
            buildable.setDiskUsage(fluent.getDiskUsage());
            buildable.setEmail(fluent.getEmail());
            buildable.setHtmlURL(fluent.getHtmlURL());
            buildable.setId(fluent.getId());
            buildable.setName(fluent.getName());
            buildable.setRepositories(fluent.getRepositories());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryOwnerBuilder that = (V1alpha1CodeRepositoryOwnerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
