package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1DocumentManagementBindingTemplateBuilder extends V1alpha1DocumentManagementBindingTemplateFluentImpl<V1alpha1DocumentManagementBindingTemplateBuilder> implements VisitableBuilder<V1alpha1DocumentManagementBindingTemplate,V1alpha1DocumentManagementBindingTemplateBuilder>{

    V1alpha1DocumentManagementBindingTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1DocumentManagementBindingTemplateBuilder(){
            this(true);
    }
    public V1alpha1DocumentManagementBindingTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1DocumentManagementBindingTemplate(), validationEnabled);
    }
    public V1alpha1DocumentManagementBindingTemplateBuilder(V1alpha1DocumentManagementBindingTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1DocumentManagementBindingTemplateBuilder(V1alpha1DocumentManagementBindingTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1DocumentManagementBindingTemplate(), validationEnabled);
    }
    public V1alpha1DocumentManagementBindingTemplateBuilder(V1alpha1DocumentManagementBindingTemplateFluent<?> fluent,V1alpha1DocumentManagementBindingTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1DocumentManagementBindingTemplateBuilder(V1alpha1DocumentManagementBindingTemplateFluent<?> fluent,V1alpha1DocumentManagementBindingTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1DocumentManagementBindingTemplateBuilder(V1alpha1DocumentManagementBindingTemplate instance){
            this(instance,true);
    }
    public V1alpha1DocumentManagementBindingTemplateBuilder(V1alpha1DocumentManagementBindingTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1DocumentManagementBindingTemplate build(){
            V1alpha1DocumentManagementBindingTemplate buildable = new V1alpha1DocumentManagementBindingTemplate();
            buildable.setSelector(fluent.getSelector());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DocumentManagementBindingTemplateBuilder that = (V1alpha1DocumentManagementBindingTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
