package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ExportShowOptionsBuilder extends V1alpha1ExportShowOptionsFluentImpl<V1alpha1ExportShowOptionsBuilder> implements VisitableBuilder<V1alpha1ExportShowOptions,V1alpha1ExportShowOptionsBuilder>{

    V1alpha1ExportShowOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ExportShowOptionsBuilder(){
            this(true);
    }
    public V1alpha1ExportShowOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1ExportShowOptions(), validationEnabled);
    }
    public V1alpha1ExportShowOptionsBuilder(V1alpha1ExportShowOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ExportShowOptionsBuilder(V1alpha1ExportShowOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ExportShowOptions(), validationEnabled);
    }
    public V1alpha1ExportShowOptionsBuilder(V1alpha1ExportShowOptionsFluent<?> fluent,V1alpha1ExportShowOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1ExportShowOptionsBuilder(V1alpha1ExportShowOptionsFluent<?> fluent,V1alpha1ExportShowOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withFormatvalue(instance.getFormatvalue());

            fluent.withKind(instance.getKind());

            fluent.withTaskName(instance.getTaskName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ExportShowOptionsBuilder(V1alpha1ExportShowOptions instance){
            this(instance,true);
    }
    public V1alpha1ExportShowOptionsBuilder(V1alpha1ExportShowOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withFormatvalue(instance.getFormatvalue());

            this.withKind(instance.getKind());

            this.withTaskName(instance.getTaskName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ExportShowOptions build(){
            V1alpha1ExportShowOptions buildable = new V1alpha1ExportShowOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setFormatvalue(fluent.getFormatvalue());
            buildable.setKind(fluent.getKind());
            buildable.setTaskName(fluent.getTaskName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ExportShowOptionsBuilder that = (V1alpha1ExportShowOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
