package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1JenkinsBindingProxyOptionsFluentImpl<A extends V1alpha1JenkinsBindingProxyOptionsFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1JenkinsBindingProxyOptionsFluent<A>{

    private String apiVersion;
    private Map<String,List<String>> header;
    private String kind;
    private String method;
    private String payload;
    private String url;

    public V1alpha1JenkinsBindingProxyOptionsFluentImpl(){
    }
    public V1alpha1JenkinsBindingProxyOptionsFluentImpl(V1alpha1JenkinsBindingProxyOptions instance){
            this.withApiVersion(instance.getApiVersion());

            this.withHeader(instance.getHeader());

            this.withKind(instance.getKind());

            this.withMethod(instance.getMethod());

            this.withPayload(instance.getPayload());

            this.withUrl(instance.getUrl());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToHeader(String key,List<String> value){
            if(this.header == null && key != null && value != null) { this.header = new LinkedHashMap<String,List<String>>(); }
            if(key != null && value != null) {this.header.put(key, value);} return (A)this;
    }

    public A addToHeader(Map<String,List<String>> map){
            if(this.header == null && map != null) { this.header = new LinkedHashMap<String,List<String>>(); }
            if(map != null) { this.header.putAll(map);} return (A)this;
    }

    public A removeFromHeader(String key){
            if(this.header == null) { return (A) this; }
            if(key != null && this.header != null) {this.header.remove(key);} return (A)this;
    }

    public A removeFromHeader(Map<String,List<String>> map){
            if(this.header == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.header != null){this.header.remove(key);}}} return (A)this;
    }

    public Map<String,List<String>> getHeader(){
            return this.header;
    }

    public A withHeader(Map<String,List<String>> header){
            if (header == null) { this.header =  null;} else {this.header = new LinkedHashMap<String,List<String>>(header);} return (A) this;
    }

    public Boolean hasHeader(){
            return this.header != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getMethod(){
            return this.method;
    }

    public A withMethod(String method){
            this.method=method; return (A) this;
    }

    public Boolean hasMethod(){
            return this.method != null;
    }

    public A withNewMethod(String arg1){
            return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuilder arg1){
            return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuffer arg1){
            return (A)withMethod(new String(arg1));
    }

    public String getPayload(){
            return this.payload;
    }

    public A withPayload(String payload){
            this.payload=payload; return (A) this;
    }

    public Boolean hasPayload(){
            return this.payload != null;
    }

    public A withNewPayload(String arg1){
            return (A)withPayload(new String(arg1));
    }

    public A withNewPayload(StringBuilder arg1){
            return (A)withPayload(new String(arg1));
    }

    public A withNewPayload(StringBuffer arg1){
            return (A)withPayload(new String(arg1));
    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsBindingProxyOptionsFluentImpl that = (V1alpha1JenkinsBindingProxyOptionsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (header != null ? !header.equals(that.header) :that.header != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (method != null ? !method.equals(that.method) :that.method != null) return false;
            if (payload != null ? !payload.equals(that.payload) :that.payload != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }




}
