package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineConfigSpecBuilder extends V1alpha1PipelineConfigSpecFluentImpl<V1alpha1PipelineConfigSpecBuilder> implements VisitableBuilder<V1alpha1PipelineConfigSpec,V1alpha1PipelineConfigSpecBuilder>{

    V1alpha1PipelineConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineConfigSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineConfigSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineConfigSpec(), validationEnabled);
    }
    public V1alpha1PipelineConfigSpecBuilder(V1alpha1PipelineConfigSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineConfigSpecBuilder(V1alpha1PipelineConfigSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineConfigSpec(), validationEnabled);
    }
    public V1alpha1PipelineConfigSpecBuilder(V1alpha1PipelineConfigSpecFluent<?> fluent,V1alpha1PipelineConfigSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineConfigSpecBuilder(V1alpha1PipelineConfigSpecFluent<?> fluent,V1alpha1PipelineConfigSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHooks(instance.getHooks());

            fluent.withJenkinsBinding(instance.getJenkinsBinding());

            fluent.withParameters(instance.getParameters());

            fluent.withRunLimits(instance.getRunLimits());

            fluent.withRunPolicy(instance.getRunPolicy());

            fluent.withSource(instance.getSource());

            fluent.withStrategy(instance.getStrategy());

            fluent.withTemplate(instance.getTemplate());

            fluent.withTriggers(instance.getTriggers());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineConfigSpecBuilder(V1alpha1PipelineConfigSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineConfigSpecBuilder(V1alpha1PipelineConfigSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHooks(instance.getHooks());

            this.withJenkinsBinding(instance.getJenkinsBinding());

            this.withParameters(instance.getParameters());

            this.withRunLimits(instance.getRunLimits());

            this.withRunPolicy(instance.getRunPolicy());

            this.withSource(instance.getSource());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

            this.withTriggers(instance.getTriggers());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineConfigSpec build(){
            V1alpha1PipelineConfigSpec buildable = new V1alpha1PipelineConfigSpec();
            buildable.setHooks(fluent.getHooks());
            buildable.setJenkinsBinding(fluent.getJenkinsBinding());
            buildable.setParameters(fluent.getParameters());
            buildable.setRunLimits(fluent.getRunLimits());
            buildable.setRunPolicy(fluent.getRunPolicy());
            buildable.setSource(fluent.getSource());
            buildable.setStrategy(fluent.getStrategy());
            buildable.setTemplate(fluent.getTemplate());
            buildable.setTriggers(fluent.getTriggers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigSpecBuilder that = (V1alpha1PipelineConfigSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
