package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineHookBuilder extends V1alpha1PipelineHookFluentImpl<V1alpha1PipelineHookBuilder> implements VisitableBuilder<V1alpha1PipelineHook,V1alpha1PipelineHookBuilder>{

    V1alpha1PipelineHookFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineHookBuilder(){
            this(true);
    }
    public V1alpha1PipelineHookBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineHook(), validationEnabled);
    }
    public V1alpha1PipelineHookBuilder(V1alpha1PipelineHookFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineHookBuilder(V1alpha1PipelineHookFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineHook(), validationEnabled);
    }
    public V1alpha1PipelineHookBuilder(V1alpha1PipelineHookFluent<?> fluent,V1alpha1PipelineHook instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineHookBuilder(V1alpha1PipelineHookFluent<?> fluent,V1alpha1PipelineHook instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEvents(instance.getEvents());

            fluent.withHttpRequest(instance.getHttpRequest());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineHookBuilder(V1alpha1PipelineHook instance){
            this(instance,true);
    }
    public V1alpha1PipelineHookBuilder(V1alpha1PipelineHook instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEvents(instance.getEvents());

            this.withHttpRequest(instance.getHttpRequest());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineHook build(){
            V1alpha1PipelineHook buildable = new V1alpha1PipelineHook();
            buildable.setEvents(fluent.getEvents());
            buildable.setHttpRequest(fluent.getHttpRequest());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineHookBuilder that = (V1alpha1PipelineHookBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
