package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1PipelineTriggeScheduleFluentImpl<A extends V1alpha1PipelineTriggeScheduleFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTriggeScheduleFluent<A>{

    private List<String> times;
    private List<String> weeks;

    public V1alpha1PipelineTriggeScheduleFluentImpl(){
    }
    public V1alpha1PipelineTriggeScheduleFluentImpl(V1alpha1PipelineTriggeSchedule instance){
            this.withTimes(instance.getTimes());

            this.withWeeks(instance.getWeeks());

    }

    public A addToTimes(int index,String item){
            if (this.times == null) {this.times = new ArrayList<String>();}
            this.times.add(index, item);
            return (A)this;
    }

    public A setToTimes(int index,String item){
            if (this.times == null) {this.times = new ArrayList<String>();}
            this.times.set(index, item); return (A)this;
    }

    public A addToTimes(String... items){
            if (this.times == null) {this.times = new ArrayList<String>();}
            for (String item : items) {this.times.add(item);} return (A)this;
    }

    public A addAllToTimes(Collection<String> items){
            if (this.times == null) {this.times = new ArrayList<String>();}
            for (String item : items) {this.times.add(item);} return (A)this;
    }

    public A removeFromTimes(String... items){
            for (String item : items) {if (this.times!= null){ this.times.remove(item);}} return (A)this;
    }

    public A removeAllFromTimes(Collection<String> items){
            for (String item : items) {if (this.times!= null){ this.times.remove(item);}} return (A)this;
    }

    public List<String> getTimes(){
            return this.times;
    }

    public String getTime(int index){
            return this.times.get(index);
    }

    public String getFirstTime(){
            return this.times.get(0);
    }

    public String getLastTime(){
            return this.times.get(times.size() - 1);
    }

    public String getMatchingTime(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: times) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingTime(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: times) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTimes(List<String> times){
            if (this.times != null) { _visitables.get("times").removeAll(this.times);}
            if (times != null) {this.times = new ArrayList<String>(); for (String item : times){this.addToTimes(item);}} else { this.times = null;} return (A) this;
    }

    public A withTimes(String... times){
            if (this.times != null) {this.times.clear();}
            if (times != null) {for (String item :times){ this.addToTimes(item);}} return (A) this;
    }

    public Boolean hasTimes(){
            return times != null && !times.isEmpty();
    }

    public A addNewTime(String arg1){
            return (A)addToTimes(new String(arg1));
    }

    public A addNewTime(StringBuilder arg1){
            return (A)addToTimes(new String(arg1));
    }

    public A addNewTime(StringBuffer arg1){
            return (A)addToTimes(new String(arg1));
    }

    public A addToWeeks(int index,String item){
            if (this.weeks == null) {this.weeks = new ArrayList<String>();}
            this.weeks.add(index, item);
            return (A)this;
    }

    public A setToWeeks(int index,String item){
            if (this.weeks == null) {this.weeks = new ArrayList<String>();}
            this.weeks.set(index, item); return (A)this;
    }

    public A addToWeeks(String... items){
            if (this.weeks == null) {this.weeks = new ArrayList<String>();}
            for (String item : items) {this.weeks.add(item);} return (A)this;
    }

    public A addAllToWeeks(Collection<String> items){
            if (this.weeks == null) {this.weeks = new ArrayList<String>();}
            for (String item : items) {this.weeks.add(item);} return (A)this;
    }

    public A removeFromWeeks(String... items){
            for (String item : items) {if (this.weeks!= null){ this.weeks.remove(item);}} return (A)this;
    }

    public A removeAllFromWeeks(Collection<String> items){
            for (String item : items) {if (this.weeks!= null){ this.weeks.remove(item);}} return (A)this;
    }

    public List<String> getWeeks(){
            return this.weeks;
    }

    public String getWeek(int index){
            return this.weeks.get(index);
    }

    public String getFirstWeek(){
            return this.weeks.get(0);
    }

    public String getLastWeek(){
            return this.weeks.get(weeks.size() - 1);
    }

    public String getMatchingWeek(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: weeks) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingWeek(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: weeks) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withWeeks(List<String> weeks){
            if (this.weeks != null) { _visitables.get("weeks").removeAll(this.weeks);}
            if (weeks != null) {this.weeks = new ArrayList<String>(); for (String item : weeks){this.addToWeeks(item);}} else { this.weeks = null;} return (A) this;
    }

    public A withWeeks(String... weeks){
            if (this.weeks != null) {this.weeks.clear();}
            if (weeks != null) {for (String item :weeks){ this.addToWeeks(item);}} return (A) this;
    }

    public Boolean hasWeeks(){
            return weeks != null && !weeks.isEmpty();
    }

    public A addNewWeek(String arg1){
            return (A)addToWeeks(new String(arg1));
    }

    public A addNewWeek(StringBuilder arg1){
            return (A)addToWeeks(new String(arg1));
    }

    public A addNewWeek(StringBuffer arg1){
            return (A)addToWeeks(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTriggeScheduleFluentImpl that = (V1alpha1PipelineTriggeScheduleFluentImpl) o;
            if (times != null ? !times.equals(that.times) :that.times != null) return false;
            if (weeks != null ? !weeks.equals(that.weeks) :that.weeks != null) return false;
            return true;
    }




}
