package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTriggersBuilder extends V1alpha1PipelineTriggersFluentImpl<V1alpha1PipelineTriggersBuilder> implements VisitableBuilder<V1alpha1PipelineTriggers,V1alpha1PipelineTriggersBuilder>{

    V1alpha1PipelineTriggersFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTriggersBuilder(){
            this(true);
    }
    public V1alpha1PipelineTriggersBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTriggers(), validationEnabled);
    }
    public V1alpha1PipelineTriggersBuilder(V1alpha1PipelineTriggersFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTriggersBuilder(V1alpha1PipelineTriggersFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTriggers(), validationEnabled);
    }
    public V1alpha1PipelineTriggersBuilder(V1alpha1PipelineTriggersFluent<?> fluent,V1alpha1PipelineTriggers instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTriggersBuilder(V1alpha1PipelineTriggersFluent<?> fluent,V1alpha1PipelineTriggers instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRaw(instance.getRaw());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTriggersBuilder(V1alpha1PipelineTriggers instance){
            this(instance,true);
    }
    public V1alpha1PipelineTriggersBuilder(V1alpha1PipelineTriggers instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRaw(instance.getRaw());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTriggers build(){
            V1alpha1PipelineTriggers buildable = new V1alpha1PipelineTriggers();
            buildable.setRaw(fluent.getRaw());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTriggersBuilder that = (V1alpha1PipelineTriggersBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
