package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1RoleMappingFluentImpl<A extends V1alpha1RoleMappingFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1RoleMappingFluent<A>{

    private String apiVersion;
    private String kind;
    private List<V1alpha1ProjectUserRoleOperationBuilder> spec;

    public V1alpha1RoleMappingFluentImpl(){
    }
    public V1alpha1RoleMappingFluentImpl(V1alpha1RoleMapping instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withSpec(instance.getSpec());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public A addToSpec(int index,V1alpha1ProjectUserRoleOperation item){
            if (this.spec == null) {this.spec = new ArrayList<V1alpha1ProjectUserRoleOperationBuilder>();}
            V1alpha1ProjectUserRoleOperationBuilder builder = new V1alpha1ProjectUserRoleOperationBuilder(item);_visitables.get("spec").add(index >= 0 ? index : _visitables.get("spec").size(), builder);this.spec.add(index >= 0 ? index : spec.size(), builder); return (A)this;
    }

    public A setToSpec(int index,V1alpha1ProjectUserRoleOperation item){
            if (this.spec == null) {this.spec = new ArrayList<V1alpha1ProjectUserRoleOperationBuilder>();}
            V1alpha1ProjectUserRoleOperationBuilder builder = new V1alpha1ProjectUserRoleOperationBuilder(item);
            if (index < 0 || index >= _visitables.get("spec").size()) { _visitables.get("spec").add(builder); } else { _visitables.get("spec").set(index, builder);}
            if (index < 0 || index >= spec.size()) { spec.add(builder); } else { spec.set(index, builder);}
             return (A)this;
    }

    public A addToSpec(V1alpha1ProjectUserRoleOperation... items){
            if (this.spec == null) {this.spec = new ArrayList<V1alpha1ProjectUserRoleOperationBuilder>();}
            for (V1alpha1ProjectUserRoleOperation item : items) {V1alpha1ProjectUserRoleOperationBuilder builder = new V1alpha1ProjectUserRoleOperationBuilder(item);_visitables.get("spec").add(builder);this.spec.add(builder);} return (A)this;
    }

    public A addAllToSpec(Collection<V1alpha1ProjectUserRoleOperation> items){
            if (this.spec == null) {this.spec = new ArrayList<V1alpha1ProjectUserRoleOperationBuilder>();}
            for (V1alpha1ProjectUserRoleOperation item : items) {V1alpha1ProjectUserRoleOperationBuilder builder = new V1alpha1ProjectUserRoleOperationBuilder(item);_visitables.get("spec").add(builder);this.spec.add(builder);} return (A)this;
    }

    public A removeFromSpec(V1alpha1ProjectUserRoleOperation... items){
            for (V1alpha1ProjectUserRoleOperation item : items) {V1alpha1ProjectUserRoleOperationBuilder builder = new V1alpha1ProjectUserRoleOperationBuilder(item);_visitables.get("spec").remove(builder);if (this.spec != null) {this.spec.remove(builder);}} return (A)this;
    }

    public A removeAllFromSpec(Collection<V1alpha1ProjectUserRoleOperation> items){
            for (V1alpha1ProjectUserRoleOperation item : items) {V1alpha1ProjectUserRoleOperationBuilder builder = new V1alpha1ProjectUserRoleOperationBuilder(item);_visitables.get("spec").remove(builder);if (this.spec != null) {this.spec.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1ProjectUserRoleOperation> getSpec(){
            return build(spec);
    }

    public List<V1alpha1ProjectUserRoleOperation> buildSpec(){
            return build(spec);
    }

    public V1alpha1ProjectUserRoleOperation buildSpec(int index){
            return this.spec.get(index).build();
    }

    public V1alpha1ProjectUserRoleOperation buildFirstSpec(){
            return this.spec.get(0).build();
    }

    public V1alpha1ProjectUserRoleOperation buildLastSpec(){
            return this.spec.get(spec.size() - 1).build();
    }

    public V1alpha1ProjectUserRoleOperation buildMatchingSpec(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ProjectUserRoleOperationBuilder> predicate){
            for (V1alpha1ProjectUserRoleOperationBuilder item: spec) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingSpec(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ProjectUserRoleOperationBuilder> predicate){
            for (V1alpha1ProjectUserRoleOperationBuilder item: spec) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSpec(List<V1alpha1ProjectUserRoleOperation> spec){
            if (this.spec != null) { _visitables.get("spec").removeAll(this.spec);}
            if (spec != null) {this.spec = new ArrayList<V1alpha1ProjectUserRoleOperationBuilder>(); for (V1alpha1ProjectUserRoleOperation item : spec){this.addToSpec(item);}} else { this.spec = null;} return (A) this;
    }

    public A withSpec(V1alpha1ProjectUserRoleOperation... spec){
            if (this.spec != null) {this.spec.clear();}
            if (spec != null) {for (V1alpha1ProjectUserRoleOperation item :spec){ this.addToSpec(item);}} return (A) this;
    }

    public Boolean hasSpec(){
            return spec != null && !spec.isEmpty();
    }

    public V1alpha1RoleMappingFluent.SpecNested<A> addNewSpec(){
            return new SpecNestedImpl();
    }

    public V1alpha1RoleMappingFluent.SpecNested<A> addNewSpecLike(V1alpha1ProjectUserRoleOperation item){
            return new SpecNestedImpl(-1, item);
    }

    public V1alpha1RoleMappingFluent.SpecNested<A> setNewSpecLike(int index,V1alpha1ProjectUserRoleOperation item){
            return new SpecNestedImpl(index, item);
    }

    public V1alpha1RoleMappingFluent.SpecNested<A> editSpec(int index){
            if (spec.size() <= index) throw new RuntimeException("Can't edit spec. Index exceeds size.");
            return setNewSpecLike(index, buildSpec(index));
    }

    public V1alpha1RoleMappingFluent.SpecNested<A> editFirstSpec(){
            if (spec.size() == 0) throw new RuntimeException("Can't edit first spec. The list is empty.");
            return setNewSpecLike(0, buildSpec(0));
    }

    public V1alpha1RoleMappingFluent.SpecNested<A> editLastSpec(){
            int index = spec.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last spec. The list is empty.");
            return setNewSpecLike(index, buildSpec(index));
    }

    public V1alpha1RoleMappingFluent.SpecNested<A> editMatchingSpec(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ProjectUserRoleOperationBuilder> predicate){
            int index = -1;
            for (int i=0;i<spec.size();i++) { 
            if (predicate.apply(spec.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching spec. No match found.");
            return setNewSpecLike(index, buildSpec(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RoleMappingFluentImpl that = (V1alpha1RoleMappingFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends V1alpha1ProjectUserRoleOperationFluentImpl<V1alpha1RoleMappingFluent.SpecNested<N>> implements V1alpha1RoleMappingFluent.SpecNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ProjectUserRoleOperationBuilder builder;
        private final int index;
    
            SpecNestedImpl(int index,V1alpha1ProjectUserRoleOperation item){
                    this.index = index;
                    this.builder = new V1alpha1ProjectUserRoleOperationBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1ProjectUserRoleOperationBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1RoleMappingFluentImpl.this.setToSpec(index, builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
