/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue.ratelimiter;

import io.alauda.devops.java.client.extend.workqueue.ratelimiter.DefaultControllerRateLimiter;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.ItemExponentialFailureRateLimiter;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.ItemFastSlowRateLimiter;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.MaxOfRateLimiter;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class MaxOfRateLimiterTest {
    @Test
    public void testMaxOfRateLimiter() {
        MaxOfRateLimiter rateLimiter = new MaxOfRateLimiter(new RateLimiter[]{new ItemFastSlowRateLimiter(Duration.ofMillis(5L), Duration.ofSeconds(3L), 3), new ItemExponentialFailureRateLimiter(Duration.ofMillis(1L), Duration.ofSeconds(1L))});
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofSeconds(3L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofSeconds(3L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((long)5L, (long)rateLimiter.numRequeues((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)rateLimiter.when((Object)"two"));
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)rateLimiter.when((Object)"two"));
        Assert.assertEquals((long)2L, (long)rateLimiter.numRequeues((Object)"two"));
        rateLimiter.forget((Object)"one");
        Assert.assertEquals((long)0L, (long)rateLimiter.numRequeues((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)rateLimiter.when((Object)"one"));
    }

    @Test
    public void testDefaultRateLimiter() {
        int i;
        DefaultControllerRateLimiter rateLimiter = new DefaultControllerRateLimiter();
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(10L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(20L), (Object)rateLimiter.when((Object)"one"));
        for (i = 0; i < 20; ++i) {
            rateLimiter.when((Object)"one");
        }
        Assert.assertEquals((Object)Duration.ofSeconds(1000L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofSeconds(1000L), (Object)rateLimiter.when((Object)"one"));
        for (i = 0; i < 75; ++i) {
            rateLimiter.when((Object)"one");
        }
        Assert.assertTrue((rateLimiter.when((Object)"one").getSeconds() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((rateLimiter.when((Object)"two").getSeconds() > 0L ? 1 : 0) != 0);
    }
}

