/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue.ratelimiter;

import com.google.common.util.concurrent.AtomicLongMap;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;

public class ItemExponentialFailureRateLimiter<T>
implements RateLimiter<T> {
    private Duration baseDelay;
    private Duration maxDelay;
    private AtomicLongMap<T> failures;

    public ItemExponentialFailureRateLimiter(Duration baseDelay, Duration maxDelay) {
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
        this.failures = AtomicLongMap.create();
    }

    @Override
    public Duration when(T item) {
        long exp = this.failures.getAndIncrement(item);
        long d = this.maxDelay.toMillis() >> (int)exp;
        return d > this.baseDelay.toMillis() ? this.baseDelay.multipliedBy(1 << (int)exp) : this.maxDelay;
    }

    @Override
    public void forget(T item) {
        this.failures.remove(item);
    }

    @Override
    public int numRequeues(T item) {
        return (int)this.failures.get(item);
    }
}

