/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.logging;

import io.appulse.logging.AnsiColor;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

final class AnsiColors {
    private static final Map<AnsiColor, LabColor> ANSI_COLOR_MAP = new ConcurrentHashMap<AnsiColor, LabColor>();

    private AnsiColors() {
    }

    static AnsiColor getClosest(Color color) {
        return AnsiColors.getClosest(new LabColor(color));
    }

    private static AnsiColor getClosest(LabColor color) {
        AnsiColor result = null;
        double resultDistance = 3.4028234663852886E38;
        for (Map.Entry<AnsiColor, LabColor> entry : ANSI_COLOR_MAP.entrySet()) {
            double distance = color.getDistance(entry.getValue());
            if (result != null && !(distance < resultDistance)) continue;
            resultDistance = distance;
            result = entry.getKey();
        }
        return result;
    }

    static {
        ANSI_COLOR_MAP.put(AnsiColor.BLACK, new LabColor(0));
        ANSI_COLOR_MAP.put(AnsiColor.RED, new LabColor(0xAA0000));
        ANSI_COLOR_MAP.put(AnsiColor.GREEN, new LabColor(43520));
        ANSI_COLOR_MAP.put(AnsiColor.YELLOW, new LabColor(0xAA5500));
        ANSI_COLOR_MAP.put(AnsiColor.BLUE, new LabColor(170));
        ANSI_COLOR_MAP.put(AnsiColor.MAGENTA, new LabColor(0xAA00AA));
        ANSI_COLOR_MAP.put(AnsiColor.CYAN, new LabColor(43690));
        ANSI_COLOR_MAP.put(AnsiColor.WHITE, new LabColor(0xAAAAAA));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_BLACK, new LabColor(0x555555));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_RED, new LabColor(0xFF5555));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_GREEN, new LabColor(0x55FF00));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_YELLOW, new LabColor(0xFFFF55));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_BLUE, new LabColor(0x5555FF));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_MAGENTA, new LabColor(0xFF55FF));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_CYAN, new LabColor(0x55FFFF));
        ANSI_COLOR_MAP.put(AnsiColor.BRIGHT_WHITE, new LabColor(0xFFFFFF));
    }

    private static final class LabColor {
        private static final ColorSpace XYZ_COLOR_SPACE = ColorSpace.getInstance(1001);
        private final double labValueL;
        private final double labValueA;
        private final double labValueB;

        LabColor(int rgb) {
            this(new Color(rgb));
        }

        LabColor(@NonNull Color color) {
            if (color == null) {
                throw new NullPointerException("color is marked @NonNull but is null");
            }
            float[] lab = this.fromXyz(color.getColorComponents(XYZ_COLOR_SPACE, null));
            this.labValueL = lab[0];
            this.labValueA = lab[1];
            this.labValueB = lab[2];
        }

        private float[] fromXyz(float[] xyz) {
            return this.fromXyz(xyz[0], xyz[1], xyz[2]);
        }

        private float[] fromXyz(float x, float y, float z) {
            return new float[]{(float)((this.function(y) - 16.0) * 116.0), (float)((this.function(x) - this.function(y)) * 500.0), (float)((this.function(y) - this.function(z)) * 200.0)};
        }

        private double function(double value) {
            return value > 0.008856451679035631 ? Math.cbrt(value) : 0.3333333333333333 * Math.pow(4.833333333333333, 2.0) * value + 0.13793103448275862;
        }

        public double getDistance(LabColor other) {
            double c1 = Math.sqrt(this.labValueA * this.labValueA + this.labValueB * this.labValueB);
            double deltaC = c1 - Math.sqrt(other.labValueA * other.labValueA + other.labValueB * other.labValueB);
            double deltaA = this.labValueA - other.labValueA;
            double deltaB = this.labValueB - other.labValueB;
            double deltaH = Math.sqrt(Math.max(0.0, deltaA * deltaA + deltaB * deltaB - deltaC * deltaC));
            return Math.sqrt(Math.max(0.0, Math.pow((this.labValueL - other.labValueL) / 1.0, 2.0) + Math.pow(deltaC / (1.0 + 0.045 * c1), 2.0) + Math.pow(deltaH / (1.0 + 0.015 * c1), 2.0)));
        }
    }
}

