/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import io.appulse.logging.AnsiColor;
import io.appulse.logging.AnsiElement;
import io.appulse.logging.AnsiOutput;
import io.appulse.logging.AnsiStyle;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final Map<String, AnsiElement> ELEMENTS = new ConcurrentHashMap<String, AnsiElement>();
    private static final Map<Integer, AnsiElement> LEVELS;

    protected String transform(ILoggingEvent event, String in) {
        AnsiElement element = Optional.ofNullable(this.getFirstOption()).map(ELEMENTS::get).filter(Objects::nonNull).orElseGet(() -> Optional.ofNullable(event.getLevel().toInteger()).map(LEVELS::get).filter(Objects::nonNull).orElse(AnsiColor.GREEN));
        return this.toAnsiString(in, element);
    }

    protected String toAnsiString(String in, AnsiElement element) {
        return AnsiOutput.toString(element, in);
    }

    static {
        ELEMENTS.put("faint", AnsiStyle.FAINT);
        ELEMENTS.put("red", AnsiColor.RED);
        ELEMENTS.put("green", AnsiColor.GREEN);
        ELEMENTS.put("yellow", AnsiColor.YELLOW);
        ELEMENTS.put("blue", AnsiColor.BLUE);
        ELEMENTS.put("magenta", AnsiColor.MAGENTA);
        ELEMENTS.put("cyan", AnsiColor.CYAN);
        LEVELS = new ConcurrentHashMap<Integer, AnsiElement>();
        LEVELS.put(Level.ERROR_INTEGER, AnsiColor.RED);
        LEVELS.put(Level.WARN_INTEGER, AnsiColor.YELLOW);
    }
}

