/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashFunction;
import io.castle.client.api.CastleApi;
import io.castle.client.internal.CastleApiImpl;
import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.config.CastleConfigurationBuilder;
import io.castle.client.internal.config.CastleSdkInternalConfiguration;
import io.castle.client.internal.json.CastleGsonModel;
import io.castle.client.internal.utils.CastleContextBuilder;
import io.castle.client.model.CastleResponse;
import io.castle.client.model.CastleSdkConfigurationException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Castle {
    public static final String URL_TRACK = "/v1/track";
    public static final String URL_AUTHENTICATE = "/v1/authenticate";
    public static final String URL_DEVICES = "/v1/devices/";
    public static final String URL_USERS = "/v1/users/";
    public static final String URL_IMPERSONATE = "/v1/impersonate";
    public static final String URL_PRIVACY = "/v1/privacy/";
    public static final String URL_RISK = "/v1/risk";
    public static final String URL_FILTER = "/v1/filter";
    public static final String URL_LOG = "/v1/log";
    public static final String URL_RECOVER = "/v1/users/%s/recover";
    public static final String KEY_EVENT = "event";
    public static final String KEY_USER = "user";
    public static final String KEY_STATUS = "status";
    public static final String KEY_FINGERPRINT = "fingerprint";
    public static final String KEY_REGISTERED_AT = "registered_at";
    public static final String KEY_CREATED_AT = "created_at";
    public static final String KEY_PROPERTIES = "properties";
    public static final String KEY_REQUEST_TOKEN = "request_token";
    public static final String KEY_CONTEXT = "context";
    public static final String KEY_IP = "ip";
    public static final String KEY_HEADERS = "headers";
    public static final String KEY_ID = "id";
    public static final String KEY_USER_ID = "user_id";
    public static final String KEY_NAME = "name";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_TRAITS = "traits";
    public static final Logger logger = LoggerFactory.getLogger(Castle.class);
    private final CastleSdkInternalConfiguration internalConfiguration;
    private static Castle instance;

    public Castle(CastleSdkInternalConfiguration internalConfiguration) {
        this.internalConfiguration = internalConfiguration;
    }

    public static Castle instance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Castle SDK must be initialized. Call `Castle.initialize()` first");
        }
        return instance;
    }

    public static void setSingletonInstance(Castle sdk) {
        if (instance == null) {
            instance = sdk;
        }
    }

    public CastleApi client() throws IllegalStateException {
        return this.buildApiClient(false);
    }

    public CastleApi client(boolean doNotTrack) throws IllegalStateException {
        return this.buildApiClient(doNotTrack);
    }

    public static Castle verifySdkConfigurationAndInitialize() throws CastleSdkConfigurationException {
        return Castle.initializeSDK();
    }

    private static synchronized Castle initializeSDK() throws CastleSdkConfigurationException {
        CastleSdkInternalConfiguration loadedConfig = CastleSdkInternalConfiguration.getInternalConfiguration();
        return new Castle(loadedConfig);
    }

    public static synchronized Castle initialize(CastleConfiguration config) throws CastleSdkConfigurationException {
        return new Castle(CastleSdkInternalConfiguration.buildFromConfiguration(config));
    }

    public static Castle initialize() throws CastleSdkConfigurationException {
        return Castle.initialize(Castle.configurationBuilder().build());
    }

    public static Castle initialize(String secret) throws CastleSdkConfigurationException {
        return Castle.initialize(Castle.configurationBuilder().apiSecret(secret).build());
    }

    public static CastleConfigurationBuilder configurationBuilder() {
        return CastleSdkInternalConfiguration.builderFromConfigurationLoader();
    }

    public CastleContextBuilder contextBuilder() {
        return this.buildContextBuilder();
    }

    public CastleContextBuilder buildContextBuilder() {
        return new CastleContextBuilder(this.getSdkConfiguration(), this.getGsonModel());
    }

    public CastleApi buildApiClient() {
        return this.buildApiClient(false);
    }

    public CastleApi buildApiClient(boolean doNotTrack) {
        return new CastleApiImpl(this.internalConfiguration, doNotTrack);
    }

    public CastleApi onRequest(HttpServletRequest request) {
        return this.onRequest(request, false);
    }

    public CastleApi onRequest(HttpServletRequest request, boolean doNotTrack) {
        return new CastleApiImpl(request, doNotTrack, this.internalConfiguration);
    }

    public CastleConfiguration getSdkConfiguration() {
        return this.internalConfiguration.getConfiguration();
    }

    private CastleGsonModel getGsonModel() {
        return this.internalConfiguration.getModel();
    }

    CastleSdkInternalConfiguration getInternalConfiguration() {
        return this.internalConfiguration;
    }

    public String secureUserID(String userId) {
        HashFunction hashFunction = this.internalConfiguration.getSecureHashFunction();
        return hashFunction.hashString((CharSequence)userId, Charsets.UTF_8).toString();
    }

    public CastleResponse get(String path) {
        return this.client().get(path);
    }

    public CastleResponse post(String path, ImmutableMap<Object, Object> payload) {
        return this.client().post(path, payload);
    }

    public CastleResponse put(String path) {
        return this.client().put(path);
    }

    public CastleResponse put(String path, ImmutableMap<Object, Object> payload) {
        return this.client().put(path, payload);
    }

    public CastleResponse delete(String path) {
        return this.client().delete(path);
    }

    public CastleResponse delete(String path, ImmutableMap<Object, Object> payload) {
        return this.client().delete(path, payload);
    }
}

