/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.castle.client.api.CastleApi;
import io.castle.client.internal.backend.RestApi;
import io.castle.client.internal.config.CastleSdkInternalConfiguration;
import io.castle.client.internal.utils.CastleContextBuilder;
import io.castle.client.internal.utils.ContextMerge;
import io.castle.client.internal.utils.Timestamp;
import io.castle.client.internal.utils.VerdictBuilder;
import io.castle.client.model.AsyncCallbackHandler;
import io.castle.client.model.AuthenticateAction;
import io.castle.client.model.CastleContext;
import io.castle.client.model.CastleMessage;
import io.castle.client.model.CastleResponse;
import io.castle.client.model.CastleRuntimeException;
import io.castle.client.model.CastleSuccess;
import io.castle.client.model.CastleUserDevice;
import io.castle.client.model.CastleUserDevices;
import io.castle.client.model.Verdict;
import io.castle.client.model.generated.Filter;
import io.castle.client.model.generated.FilterResponse;
import io.castle.client.model.generated.Log;
import io.castle.client.model.generated.Risk;
import io.castle.client.model.generated.RiskResponse;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class CastleApiImpl
implements CastleApi {
    private final boolean doNotTrack;
    private final CastleSdkInternalConfiguration configuration;
    private final JsonObject contextJson;

    public CastleApiImpl(HttpServletRequest request, boolean doNotTrack, CastleSdkInternalConfiguration configuration) {
        this.doNotTrack = doNotTrack;
        this.configuration = configuration;
        CastleContext castleContext = this.buildContext(request);
        this.contextJson = configuration.getModel().getGson().toJsonTree((Object)castleContext).getAsJsonObject();
    }

    public CastleApiImpl(CastleSdkInternalConfiguration configuration, boolean doNotTrack) {
        this.doNotTrack = doNotTrack;
        this.configuration = configuration;
        this.contextJson = null;
    }

    private CastleApiImpl(boolean doNotTrack, CastleSdkInternalConfiguration configuration, JsonObject contextJson) {
        this.doNotTrack = doNotTrack;
        this.configuration = configuration;
        this.contextJson = contextJson;
    }

    private CastleContext buildContext(HttpServletRequest request) {
        CastleContextBuilder builder = new CastleContextBuilder(this.configuration.getConfiguration(), this.configuration.getModel());
        CastleContext context = builder.fromHttpServletRequest(request).build();
        return context;
    }

    @Override
    public CastleApi mergeContext(Object additionalContext) {
        JsonObject contextToMerge = null;
        if (additionalContext != null) {
            contextToMerge = this.configuration.getModel().getGson().toJsonTree(additionalContext).getAsJsonObject();
        }
        JsonObject mergedContext = new ContextMerge().merge(this.contextJson, contextToMerge);
        return new CastleApiImpl(this.doNotTrack, this.configuration, mergedContext);
    }

    @Override
    public CastleApi doNotTrack(boolean doNotTrack) {
        return new CastleApiImpl(doNotTrack, this.configuration, this.contextJson);
    }

    @Override
    public Verdict authenticate(String event, String userId) {
        return this.authenticate(event, userId, null, null);
    }

    @Override
    public Verdict authenticate(String event, String userId, @Nullable Object properties, @Nullable Object traits) {
        return this.authenticate(this.buildMessage(event, userId, properties, traits));
    }

    @Override
    public Verdict authenticate(CastleMessage message) {
        JsonElement request = this.buildAuthenticateRequest(message);
        return this.sendAuthenticateRequest(request);
    }

    @Override
    public JsonElement buildAuthenticateRequest(CastleMessage message) {
        return this.buildJson(message);
    }

    @Override
    public Verdict sendAuthenticateRequest(JsonElement request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request json can not be null");
        if (this.doNotTrack) {
            return this.buildVerdictForDoNotTrack(request.getAsJsonObject().get("user_id").getAsString());
        }
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendAuthenticateSync(request);
    }

    @Override
    public void sendAuthenticateRequest(JsonElement request, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        Preconditions.checkNotNull((Object)request, (Object)"Request json can not be null");
        if (this.doNotTrack) {
            asyncCallbackHandler.onResponse(this.buildVerdictForDoNotTrack(request.getAsJsonObject().get("user_id").getAsString()));
        } else {
            Preconditions.checkNotNull(asyncCallbackHandler, (Object)"The async handler can not be null");
            RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
            restApi.sendAuthenticateAsync(request, asyncCallbackHandler);
        }
    }

    private Verdict buildVerdictForDoNotTrack(String userId) {
        return VerdictBuilder.failover("Castle set to do not track.").withAction(AuthenticateAction.ALLOW).withUserId(userId).build();
    }

    @Override
    public void authenticateAsync(String event, String userId, @Nullable Object properties, @Nullable Object traits, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        this.authenticateAsync(this.buildMessage(event, userId, properties, traits), asyncCallbackHandler);
    }

    @Override
    public void authenticateAsync(String event, String userId, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        this.authenticateAsync(CastleMessage.builder(event).userId(userId).build(), asyncCallbackHandler);
    }

    @Override
    public void authenticateAsync(CastleMessage message, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        JsonElement request = this.buildAuthenticateRequest(message);
        this.sendAuthenticateRequest(request, asyncCallbackHandler);
    }

    @Override
    public void track(String event) {
        this.track(event, null, null, null, null);
    }

    @Override
    public void track(String event, String userId) {
        this.track(event, userId, null, null, null);
    }

    @Override
    public void track(String event, @Nullable String userId, @Nullable String reviewId) {
        this.track(event, userId, reviewId, null, null, null);
    }

    @Override
    public void track(String event, String userId, String reviewId, Object properties) {
        this.track(event, userId, reviewId, properties, null, null);
    }

    @Override
    public void track(String event, @Nullable String userId, @Nullable String reviewId, @Nullable Object properties, @Nullable Object traits) {
        this.track(event, userId, reviewId, properties, traits, null);
    }

    @Override
    public void track(String event, @Nullable String userId, @Nullable String reviewId, @Nullable Object properties, @Nullable Object traits, AsyncCallbackHandler<Boolean> asyncCallbackHandler) {
        CastleMessage message = this.buildMessage(event, userId, properties, traits);
        if (reviewId != null) {
            message.setReviewId(reviewId);
        }
        this.track(message, asyncCallbackHandler);
    }

    @Override
    public void track(CastleMessage message) {
        this.track(message, null);
    }

    @Override
    public JsonElement buildTrackRequest(CastleMessage message) {
        Preconditions.checkNotNull((Object)message.getEvent());
        return this.buildJson(message);
    }

    @Override
    public void sendTrackRequest(JsonElement request) {
        this.sendTrackRequest(request, null);
    }

    @Override
    public void sendTrackRequest(JsonElement request, AsyncCallbackHandler<Boolean> asyncCallbackHandler) {
        Preconditions.checkNotNull((Object)request, (Object)"Request json can not be null");
        if (this.doNotTrack) {
            if (asyncCallbackHandler != null) {
                asyncCallbackHandler.onResponse(true);
            }
            return;
        }
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        restApi.sendTrackRequest(request, asyncCallbackHandler);
    }

    @Override
    public void track(CastleMessage message, @Nullable AsyncCallbackHandler<Boolean> asyncCallbackHandler) {
        JsonElement messageJson = this.buildTrackRequest(message);
        this.sendTrackRequest(messageJson, asyncCallbackHandler);
    }

    @Override
    public Boolean removeUser(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendPrivacyRemoveUser(userId);
    }

    @Override
    public CastleUserDevice approve(String deviceToken) {
        Preconditions.checkNotNull((Object)deviceToken);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendApproveDeviceRequestSync(deviceToken);
    }

    @Override
    public CastleUserDevice report(String deviceToken) {
        Preconditions.checkNotNull((Object)deviceToken);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendReportDeviceRequestSync(deviceToken);
    }

    @Override
    public CastleUserDevices userDevices(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendGetUserDevicesRequestSync(userId);
    }

    @Override
    public CastleUserDevice device(String deviceToken) {
        Preconditions.checkNotNull((Object)deviceToken);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendGetUserDeviceRequestSync(deviceToken);
    }

    @Override
    public CastleSuccess impersonateStart(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateStartRequestSync(userId, null, this.contextJson);
    }

    @Override
    public CastleSuccess impersonateStart(String userId, String impersonator) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateStartRequestSync(userId, impersonator, this.contextJson);
    }

    @Override
    public CastleSuccess impersonateEnd(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateEndRequestSync(userId, "", this.contextJson);
    }

    @Override
    public CastleSuccess impersonateEnd(String userId, String impersonator) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateEndRequestSync(userId, impersonator, this.contextJson);
    }

    @Override
    public CastleResponse get(String path) {
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.get(path);
    }

    @Override
    public CastleResponse post(String path, Object payload) {
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.post(path, payload);
    }

    @Override
    public CastleResponse put(String path) {
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.put(path);
    }

    @Override
    public CastleResponse put(String path, Object payload) {
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.put(path, payload);
    }

    @Override
    public CastleResponse delete(String path) {
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.delete(path);
    }

    @Override
    public CastleResponse delete(String path, Object payload) {
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.delete(path, payload);
    }

    @Override
    public CastleResponse risk(ImmutableMap<Object, Object> payload) {
        Preconditions.checkNotNull(payload);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.post("/v1/risk", payload);
    }

    @Override
    public RiskResponse risk(Risk payload) {
        Preconditions.checkNotNull((Object)payload);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        CastleResponse castleResponse = restApi.post("/v1/risk", payload);
        return (RiskResponse)this.configuration.getModel().getGson().fromJson(castleResponse.json(), RiskResponse.class);
    }

    @Override
    public CastleResponse filter(ImmutableMap<Object, Object> payload) {
        Preconditions.checkNotNull(payload);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.post("/v1/filter", payload);
    }

    @Override
    public FilterResponse filter(Filter payload) {
        Preconditions.checkNotNull((Object)payload);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        CastleResponse castleResponse = restApi.post("/v1/filter", payload);
        return (FilterResponse)this.configuration.getModel().getGson().fromJson(castleResponse.json(), FilterResponse.class);
    }

    @Override
    public CastleResponse log(ImmutableMap<Object, Object> payload) {
        Preconditions.checkNotNull(payload);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.post("/v1/log", payload);
    }

    @Override
    public CastleResponse log(Log payload) {
        Preconditions.checkNotNull((Object)payload);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.post("/v1/log", payload);
    }

    @Override
    public CastleResponse recover(String userId) {
        Preconditions.checkNotNull((Object)userId, (Object)"UserId can not be null");
        Preconditions.checkArgument((!userId.isEmpty() ? 1 : 0) != 0);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.put(String.format("/v1/users/%s/recover", userId));
    }

    private CastleMessage buildMessage(String event, String userId, @Nullable Object properties, @Nullable Object traits) {
        CastleMessage message = new CastleMessage(event);
        message.setUserId(userId);
        return this.setTraitsAndProperties(message, properties, traits);
    }

    private CastleMessage setTraitsAndProperties(CastleMessage message, @Nullable Object properties, @Nullable Object traits) {
        if (properties != null) {
            JsonElement propertiesJson = this.configuration.getModel().getGson().toJsonTree(properties);
            message.setProperties(propertiesJson);
        }
        if (traits != null) {
            JsonElement traitsJson = this.configuration.getModel().getGson().toJsonTree(traits);
            message.setUserTraits(traitsJson);
        }
        return message;
    }

    private JsonElement buildJson(CastleMessage message) throws CastleRuntimeException {
        CastleContext context = message.getContext();
        JsonObject contextJson = context == null ? this.contextJson : this.configuration.getModel().getGson().toJsonTree((Object)context).getAsJsonObject();
        JsonElement messageJson = this.configuration.getModel().getGson().toJsonTree((Object)message);
        JsonObject messageObj = messageJson.getAsJsonObject();
        messageObj.add("context", (JsonElement)contextJson);
        messageObj.addProperty("sent_at", Timestamp.timestamp());
        return messageObj;
    }
}

