/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.backend;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.castle.client.Castle;
import io.castle.client.internal.backend.RestApi;
import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.json.CastleGsonModel;
import io.castle.client.internal.utils.OkHttpExceptionUtil;
import io.castle.client.internal.utils.VerdictBuilder;
import io.castle.client.internal.utils.VerdictTransportModel;
import io.castle.client.model.AsyncCallbackHandler;
import io.castle.client.model.CastleApiInternalServerErrorException;
import io.castle.client.model.CastleResponse;
import io.castle.client.model.CastleRuntimeException;
import io.castle.client.model.CastleSuccess;
import io.castle.client.model.CastleUser;
import io.castle.client.model.CastleUserDevice;
import io.castle.client.model.CastleUserDevices;
import io.castle.client.model.ImpersonatePayload;
import io.castle.client.model.Verdict;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkRestApiBackend
implements RestApi {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_GET = "GET";
    private final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client;
    private final CastleGsonModel model;
    private final CastleConfiguration configuration;
    private final HttpUrl baseUrl;
    private final HttpUrl track;
    private final HttpUrl authenticate;
    private final HttpUrl deviceBase;
    private final HttpUrl userBase;
    private final HttpUrl impersonateBase;
    private final HttpUrl privacyBase;

    public OkRestApiBackend(OkHttpClient client, CastleGsonModel model, CastleConfiguration configuration) {
        this.baseUrl = HttpUrl.parse((String)configuration.getApiBaseUrl());
        this.client = client;
        this.model = model;
        this.configuration = configuration;
        this.track = this.baseUrl.resolve("/v1/track");
        this.authenticate = this.baseUrl.resolve("/v1/authenticate");
        this.deviceBase = this.baseUrl.resolve("/v1/devices/");
        this.userBase = this.baseUrl.resolve("/v1/users/");
        this.impersonateBase = this.baseUrl.resolve("/v1/impersonate");
        this.privacyBase = this.baseUrl.resolve("/v1/privacy/");
    }

    @Override
    public void sendTrackRequest(JsonElement payload, final AsyncCallbackHandler<Boolean> asyncCallbackHandler) {
        RequestBody body = this.buildRequestBody(payload);
        Request request = new Request.Builder().url(this.track).post(body).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                Castle.logger.error("HTTP layer. Error sending track request.", (Throwable)e);
                if (asyncCallbackHandler != null) {
                    asyncCallbackHandler.onException(e);
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (asyncCallbackHandler != null) {
                        asyncCallbackHandler.onResponse(response.isSuccessful());
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Verdict sendAuthenticateSync(JsonElement payloadJson) {
        String userId = this.getUserIdFromPayload(payloadJson);
        RequestBody body = this.buildRequestBody(payloadJson);
        Request request = new Request.Builder().url(this.authenticate).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            Verdict verdict = this.extractAuthenticationAction(response, userId);
            return verdict;
        }
        catch (IOException e) {
            Castle.logger.error("HTTP layer. Error sending request.", (Throwable)e);
            if (!this.configuration.getAuthenticateFailoverStrategy().isThrowTimeoutException()) return VerdictBuilder.failover(e.getMessage()).withAction(this.configuration.getAuthenticateFailoverStrategy().getDefaultAction()).withUserId(userId).build();
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    @Override
    public void sendAuthenticateAsync(JsonElement payloadJson, final AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        final String userId = this.getUserIdFromPayload(payloadJson);
        RequestBody body = this.buildRequestBody(payloadJson);
        Request request = new Request.Builder().url(this.authenticate).post(body).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRestApiBackend.this.configuration.getAuthenticateFailoverStrategy().isThrowTimeoutException()) {
                    asyncCallbackHandler.onException(OkHttpExceptionUtil.handle(e));
                } else {
                    asyncCallbackHandler.onResponse(VerdictBuilder.failover(e.getMessage()).withAction(OkRestApiBackend.this.configuration.getAuthenticateFailoverStrategy().getDefaultAction()).withUserId(userId).build());
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    asyncCallbackHandler.onResponse(OkRestApiBackend.this.extractAuthenticationAction(response, userId));
                }
            }
        });
    }

    private String getUserIdFromPayload(JsonElement payloadJson) {
        String userId;
        String string = userId = ((JsonObject)payloadJson).has("user_id") ? ((JsonObject)payloadJson).get("user_id").getAsString() : null;
        if (userId == null) {
            Castle.logger.warn("Authenticate called with user_id null. Is this correct?");
        }
        return userId;
    }

    private RequestBody buildRequestBody(JsonElement payloadJson) {
        JsonObject json = payloadJson.getAsJsonObject();
        return RequestBody.create((String)json.toString(), (MediaType)this.JSON);
    }

    private Verdict extractAuthenticationAction(Response response, String userId) throws IOException {
        String errorReason = response.message();
        String jsonResponse = response.body().string();
        if (response.isSuccessful()) {
            Gson gson = this.model.getGson();
            VerdictTransportModel transport = (VerdictTransportModel)gson.fromJson(jsonResponse, VerdictTransportModel.class);
            if (transport != null && transport.getAction() != null) {
                return VerdictBuilder.fromTransport(transport, JsonParser.parseString((String)jsonResponse));
            }
            errorReason = "Invalid JSON in response";
        }
        if (response.code() >= 500) {
            if (!this.configuration.getAuthenticateFailoverStrategy().isThrowTimeoutException()) {
                Verdict verdict = VerdictBuilder.failover(errorReason).withAction(this.configuration.getAuthenticateFailoverStrategy().getDefaultAction()).withUserId(userId).build();
                return verdict;
            }
            throw new CastleApiInternalServerErrorException(response);
        }
        throw new CastleRuntimeException(response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean sendPrivacyRemoveUser(String userId) {
        Request request = this.createPrivacyRemoveRequest(userId);
        try (Response response = this.client.newCall(request).execute();){
            Boolean bl = this.extractResponse(response);
            return bl;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CastleUserDevice sendApproveDeviceRequestSync(String deviceToken) {
        Request request = this.createApproveDeviceRequest(deviceToken);
        try (Response response = this.client.newCall(request).execute();){
            CastleUserDevice castleUserDevice = this.extractDevice(response);
            return castleUserDevice;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CastleUserDevice sendReportDeviceRequestSync(String deviceToken) {
        Request request = this.createReportDeviceRequest(deviceToken);
        try (Response response = this.client.newCall(request).execute();){
            CastleUserDevice castleUserDevice = this.extractDevice(response);
            return castleUserDevice;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CastleUserDevices sendGetUserDevicesRequestSync(String userId) {
        Request request = this.createGetUserDevicesRequest(userId);
        try (Response response = this.client.newCall(request).execute();){
            CastleUserDevices castleUserDevices = this.extractDevices(response);
            return castleUserDevices;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CastleUserDevice sendGetUserDeviceRequestSync(String deviceToken) {
        Request request = this.createGetUserDeviceRequest(deviceToken);
        try (Response response = this.client.newCall(request).execute();){
            CastleUserDevice castleUserDevice = this.extractDevice(response);
            return castleUserDevice;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CastleSuccess sendImpersonateStartRequestSync(String userId, String impersonator, JsonObject contextJson) {
        Request request = this.createImpersonateStartRequest(userId, impersonator, contextJson);
        try (Response response = this.client.newCall(request).execute();){
            CastleSuccess castleSuccess = this.extractSuccess(response);
            return castleSuccess;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CastleSuccess sendImpersonateEndRequestSync(String userId, String impersonator, JsonObject contextJson) {
        Request request = this.createImpersonateEndRequest(userId, impersonator, contextJson);
        try (Response response = this.client.newCall(request).execute();){
            CastleSuccess castleSuccess = this.extractSuccess(response);
            return castleSuccess;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    @Override
    public CastleResponse get(String path) {
        return this.makeRequest(path, null, METHOD_GET);
    }

    @Override
    public CastleResponse put(String path) {
        return this.makeRequest(path, null, METHOD_PUT);
    }

    @Override
    public CastleResponse put(String path, Object payload) {
        return this.makeRequest(path, this.model.getGson().toJsonTree(payload), METHOD_PUT);
    }

    @Override
    public CastleResponse delete(String path) {
        return this.makeRequest(path, null, METHOD_DELETE);
    }

    @Override
    public CastleResponse delete(String path, Object payload) {
        return this.makeRequest(path, this.model.getGson().toJsonTree(payload), METHOD_DELETE);
    }

    @Override
    public CastleResponse post(String path, Object payload) {
        return this.makeRequest(path, this.model.getGson().toJsonTree(payload), METHOD_POST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CastleResponse makeRequest(String path, JsonElement payload, String method) {
        RequestBody body = payload != null ? RequestBody.create((String)payload.toString(), (MediaType)this.JSON) : this.createEmptyRequestBody();
        Request.Builder builder = new Request.Builder().url(this.baseUrl.resolve(path));
        switch (method) {
            case "DELETE": {
                builder.delete(body);
                break;
            }
            case "POST": {
                builder.post(body);
                break;
            }
            case "PUT": {
                builder.put(body);
                break;
            }
            case "GET": {
                builder.get();
                break;
            }
        }
        Request request = builder.build();
        try (Response response = this.client.newCall(request).execute();){
            CastleResponse castleResponse = new CastleResponse(response);
            return castleResponse;
        }
        catch (IOException e) {
            throw OkHttpExceptionUtil.handle(e);
        }
    }

    private CastleUserDevice extractDevice(Response response) throws IOException {
        return (CastleUserDevice)this.extract(response, CastleUserDevice.class);
    }

    private CastleUserDevices extractDevices(Response response) throws IOException {
        return (CastleUserDevices)this.extract(response, CastleUserDevices.class);
    }

    private Object extract(Response response, Class clazz) throws IOException {
        if (response.isSuccessful()) {
            String jsonResponse = response.body().string();
            Gson gson = this.model.getGson();
            return gson.fromJson(jsonResponse, clazz);
        }
        if (response.code() == 404) {
            return null;
        }
        OkHttpExceptionUtil.handle(response);
        return null;
    }

    private CastleSuccess extractSuccess(Response response) throws IOException {
        if (response.isSuccessful() && response.body() != null) {
            String jsonResponse = response.body().string();
            Gson gson = this.model.getGson();
            return (CastleSuccess)gson.fromJson(jsonResponse, CastleSuccess.class);
        }
        OkHttpExceptionUtil.handle(response);
        return null;
    }

    private Boolean extractResponse(Response response) {
        if (response.isSuccessful()) {
            return true;
        }
        if (response.code() == 404) {
            return null;
        }
        OkHttpExceptionUtil.handle(response);
        return false;
    }

    private CastleUser extractUser(Response response) throws IOException {
        return (CastleUser)this.extract(response, CastleUser.class);
    }

    private Request createApproveDeviceRequest(String deviceToken) {
        HttpUrl approveDeviceUrl = this.deviceBase.resolve(deviceToken + "/approve");
        return new Request.Builder().url(approveDeviceUrl).put(this.createEmptyRequestBody()).build();
    }

    private Request createReportDeviceRequest(String deviceToken) {
        HttpUrl reportDeviceUrl = this.deviceBase.resolve(deviceToken + "/report");
        return new Request.Builder().url(reportDeviceUrl).put(this.createEmptyRequestBody()).build();
    }

    private Request createGetUserDevicesRequest(String userId) {
        HttpUrl getUserDevicesUrl = this.userBase.resolve(userId + "/devices");
        return new Request.Builder().url(getUserDevicesUrl).get().build();
    }

    private Request createGetUserDeviceRequest(String deviceToken) {
        HttpUrl getUserDeviceUrl = this.deviceBase.resolve(deviceToken);
        return new Request.Builder().url(getUserDeviceUrl).get().build();
    }

    private Request createImpersonateStartRequest(String userId, String impersonator, JsonObject contextJson) {
        HttpUrl impersonateUrl = this.impersonateBase;
        ImpersonatePayload payload = new ImpersonatePayload(userId, impersonator, contextJson);
        RequestBody body = RequestBody.create((String)this.model.getGson().toJson((Object)payload), (MediaType)this.JSON);
        return new Request.Builder().url(impersonateUrl).post(body).build();
    }

    private Request createImpersonateEndRequest(String userId, String impersonator, JsonObject contextJson) {
        HttpUrl impersonateUrl = this.impersonateBase;
        ImpersonatePayload payload = new ImpersonatePayload(userId, impersonator, contextJson);
        RequestBody body = RequestBody.create((String)this.model.getGson().toJson((Object)payload), (MediaType)this.JSON);
        return new Request.Builder().url(impersonateUrl).delete(body).build();
    }

    private Request createPrivacyRemoveRequest(String userId) {
        HttpUrl privacyRemoveUrl = this.privacyBase.resolve("users/" + userId);
        return new Request.Builder().url(privacyRemoveUrl).delete().build();
    }

    private RequestBody createEmptyRequestBody() {
        return RequestBody.create((byte[])new byte[0], null);
    }
}

