/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.config;

import io.castle.client.internal.backend.CastleBackendProvider;
import io.castle.client.model.AuthenticateFailoverStrategy;
import io.castle.client.model.CastleRuntimeException;
import java.util.List;

public class CastleConfiguration {
    private final String apiBaseUrl;
    private final int timeout;
    private final AuthenticateFailoverStrategy authenticateFailoverStrategy;
    private final List<String> allowListHeaders;
    private final List<String> denyListHeaders;
    private final String apiSecret;
    private final String castleAppId;
    private final CastleBackendProvider backendProvider;
    private final boolean logHttpRequests;
    private final List<String> ipHeaders;
    private final int maxRequests;

    public CastleConfiguration(String apiBaseUrl, int timeout, AuthenticateFailoverStrategy authenticateFailoverStrategy, List<String> allowListHeaders, List<String> denyListHeaders, String apiSecret, String castleAppId, CastleBackendProvider backendProvider, boolean logHttpRequests, List<String> ipHeaders, Integer maxRequests) {
        this.apiBaseUrl = apiBaseUrl;
        this.timeout = timeout;
        this.authenticateFailoverStrategy = authenticateFailoverStrategy;
        this.allowListHeaders = allowListHeaders;
        this.denyListHeaders = denyListHeaders;
        this.apiSecret = apiSecret;
        this.castleAppId = castleAppId;
        this.backendProvider = backendProvider;
        this.logHttpRequests = logHttpRequests;
        this.ipHeaders = ipHeaders;
        this.maxRequests = maxRequests;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public AuthenticateFailoverStrategy getAuthenticateFailoverStrategy() {
        return this.authenticateFailoverStrategy;
    }

    public List<String> getAllowListHeaders() {
        return this.allowListHeaders;
    }

    public List<String> getDenyListHeaders() {
        return this.denyListHeaders;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCastleAppId() throws CastleRuntimeException {
        if (this.castleAppId == null || this.castleAppId.isEmpty()) {
            throw new CastleRuntimeException("AppId was not specified");
        }
        return this.castleAppId;
    }

    public CastleBackendProvider getBackendProvider() {
        return this.backendProvider;
    }

    public boolean isLogHttpRequests() {
        return this.logHttpRequests;
    }

    public List<String> getIpHeaders() {
        return this.ipHeaders;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }
}

