/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.castle.client.internal.backend.CastleBackendProvider;
import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.utils.HeaderNormalizer;
import io.castle.client.model.AuthenticateAction;
import io.castle.client.model.AuthenticateFailoverStrategy;
import io.castle.client.model.CastleSdkConfigurationException;
import java.util.LinkedList;
import java.util.List;

public class CastleConfigurationBuilder {
    private int timeout = 500;
    private AuthenticateFailoverStrategy failoverStrategy;
    private List<String> allowListHeaders;
    private List<String> denyListHeaders;
    private String apiSecret;
    private String castleAppId;
    private CastleBackendProvider backendProvider = CastleBackendProvider.OKHTTP;
    private String apiBaseUrl;
    private boolean logHttpRequests = false;
    private List<String> ipHeaders;
    private int maxRequests = 5;

    private CastleConfigurationBuilder() {
    }

    public static CastleConfigurationBuilder defaultConfigBuilder() {
        CastleConfigurationBuilder builder = new CastleConfigurationBuilder().withDefaultAllowList().withDefaultDenyList().withDefaultApiBaseUrl().withTimeout(500).withDefaultAuthenticateFailoverStrategy().withDefaultBackendProvider().withMaxRequests(5);
        return builder;
    }

    public static CastleConfigurationBuilder aConfigBuilder() {
        return new CastleConfigurationBuilder();
    }

    public CastleConfigurationBuilder withDefaultAllowList() {
        this.allowListHeaders = new LinkedList<String>();
        return this;
    }

    public CastleConfigurationBuilder withDefaultDenyList() {
        this.denyListHeaders = new LinkedList<String>();
        this.denyListHeaders.add("Cookie");
        this.denyListHeaders.add("Authorization");
        return this;
    }

    public CastleConfigurationBuilder withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public CastleConfigurationBuilder withAuthenticateFailoverStrategy(AuthenticateFailoverStrategy failoverStrategy) {
        this.failoverStrategy = failoverStrategy;
        return this;
    }

    public CastleConfigurationBuilder withDefaultAuthenticateFailoverStrategy() {
        return this.withAuthenticateFailoverStrategy(new AuthenticateFailoverStrategy(AuthenticateAction.ALLOW));
    }

    public CastleConfigurationBuilder withDefaultApiBaseUrl() {
        return this.withApiBaseUrl("https://api.castle.io/");
    }

    public CastleConfigurationBuilder withDefaultBackendProvider() {
        return this.withBackendProvider(CastleBackendProvider.OKHTTP);
    }

    public CastleConfigurationBuilder withMaxRequests(Integer maxRequests) {
        this.maxRequests = maxRequests;
        return this;
    }

    public CastleConfigurationBuilder withAllowListHeaders(List<String> allowListedHeaders) {
        this.allowListHeaders = allowListedHeaders;
        return this;
    }

    public CastleConfigurationBuilder withAllowListHeaders(String ... allowListedHeaders) {
        return this.withAllowListHeaders((List<String>)ImmutableList.copyOf((Object[])allowListedHeaders));
    }

    public CastleConfigurationBuilder withDenyListHeaders(String ... denyListedHeaders) {
        return this.withDenyListHeaders((List<String>)ImmutableList.copyOf((Object[])denyListedHeaders));
    }

    public CastleConfigurationBuilder withDenyListHeaders(List<String> denyListedHeaders) {
        this.denyListHeaders = denyListedHeaders;
        return this;
    }

    public CastleConfigurationBuilder withApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return this;
    }

    public CastleConfigurationBuilder apiSecret(String apiSecret) {
        return this.withApiSecret(apiSecret);
    }

    public CastleConfiguration build() throws CastleSdkConfigurationException {
        ImmutableList errorMessages;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.apiSecret == null || this.apiSecret.isEmpty()) {
            builder.add((Object)"The apiSecret for the castleSDK must be provided in the configuration. Read documentation for further details.");
        }
        if (this.allowListHeaders == null) {
            builder.add((Object)"An allowList of headers must be provided. If not sure, then use the default values provided by method withDefaultAllowList. Read documentation for further details.");
        }
        if (this.denyListHeaders == null) {
            builder.add((Object)"A denyList of headers must be provided. If not sure, then use the default values provided by method withDefaultDenyList. Read documentation for further details.");
        }
        if (this.failoverStrategy == null) {
            builder.add((Object)"A failover strategy must be provided. If not sure, then use the default values provided by method withDefaultAuthenticateFailoverStrategy. Read documentation for further details.");
        }
        if (this.backendProvider == null) {
            builder.add((Object)"A backend provider must be selected. If not sure, then use the default values provided by method withDefaultBackendProvider. Read documentation for further details.");
        }
        if (this.apiBaseUrl == null) {
            builder.add((Object)"A apiBaseUrl value must be selected. If not sure, then use the default values provided by method withDefaultApiBaseUrl. Read documentation for further details.");
        }
        if (!(errorMessages = builder.build()).isEmpty()) {
            throw new CastleSdkConfigurationException(Joiner.on((String)System.lineSeparator()).join((Iterable)errorMessages));
        }
        HeaderNormalizer normalizer = new HeaderNormalizer();
        return new CastleConfiguration(this.apiBaseUrl, this.timeout, this.failoverStrategy, normalizer.normalizeList(this.allowListHeaders), normalizer.normalizeList(this.denyListHeaders), this.apiSecret, this.castleAppId, this.backendProvider, this.logHttpRequests, this.ipHeaders, this.maxRequests);
    }

    public CastleConfigurationBuilder withCastleAppId(String castleAppId) {
        this.castleAppId = castleAppId;
        return this;
    }

    public CastleConfigurationBuilder appId(String appId) {
        return this.withCastleAppId(appId);
    }

    public CastleConfigurationBuilder withBackendProvider(CastleBackendProvider backendProvider) {
        this.backendProvider = backendProvider;
        return this;
    }

    public CastleConfigurationBuilder withApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        return this;
    }

    public CastleConfigurationBuilder withLogHttpRequests(Boolean logHttpRequests) {
        this.logHttpRequests = logHttpRequests;
        return this;
    }

    public CastleConfigurationBuilder enableHttpLogging(Boolean logHttpRequests) {
        return this.withLogHttpRequests(logHttpRequests);
    }

    public CastleConfigurationBuilder withIPHeaders(List<String> ipHeaders) {
        this.ipHeaders = ipHeaders;
        return this;
    }

    public CastleConfigurationBuilder ipHeaders(List<String> ipHeaders) {
        return this.withIPHeaders(ipHeaders);
    }
}

