/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.config;

import com.google.common.base.Splitter;
import io.castle.client.Castle;
import io.castle.client.internal.backend.CastleBackendProvider;
import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.config.CastleConfigurationBuilder;
import io.castle.client.internal.config.PropertiesReader;
import io.castle.client.model.AuthenticateAction;
import io.castle.client.model.AuthenticateFailoverStrategy;
import io.castle.client.model.CastleSdkConfigurationException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

class ConfigurationLoader {
    private final Properties castleConfigurationProperties;

    ConfigurationLoader(Properties properties) {
        this.castleConfigurationProperties = properties;
    }

    ConfigurationLoader() {
        this(ConfigurationLoader.loadPropertiesFile());
    }

    private static Properties loadPropertiesFile() {
        String propertyFile = ConfigurationLoader.getPropertiesFilePath();
        Properties loaded = new Properties();
        URL configFile = Castle.class.getClassLoader().getResource(propertyFile);
        if (configFile != null) {
            InputStream resourceAsStream = Castle.class.getClassLoader().getResourceAsStream(propertyFile);
            loaded = new PropertiesReader().loadPropertiesFromStream(loaded, resourceAsStream);
        }
        return loaded;
    }

    private static String getPropertiesFilePath() {
        String propertiesFile = System.getenv("CASTLE_PROPERTIES_FILE");
        if (propertiesFile != null) {
            return propertiesFile;
        }
        return "castle_sdk.properties";
    }

    public CastleConfiguration loadConfiguration() throws CastleSdkConfigurationException, NumberFormatException {
        CastleConfigurationBuilder builder = this.loadConfigurationBuilder();
        return builder.build();
    }

    public CastleConfigurationBuilder loadConfigurationBuilder() {
        String envApiSecret = this.loadConfigurationValue(this.castleConfigurationProperties, "api_secret", "CASTLE_API_SECRET");
        if (envApiSecret == null) {
            envApiSecret = this.loadConfigurationValue(this.castleConfigurationProperties, "api_secret", "CASTLE_SDK_API_SECRET");
        }
        String castleAppId = this.loadConfigurationValue(this.castleConfigurationProperties, "app_id", "CASTLE_SDK_APP_ID");
        String allowListValue = this.loadConfigurationValue(this.castleConfigurationProperties, "allow_list", "CASTLE_SDK_ALLOWLIST_HEADERS");
        String denyListValue = this.loadConfigurationValue(this.castleConfigurationProperties, "deny_list", "CASTLE_SDK_DENYLIST_HEADERS");
        String timeoutValue = this.loadConfigurationValue(this.castleConfigurationProperties, "timeout", "CASTLE_SDK_TIMEOUT");
        String backendProviderValue = this.loadConfigurationValue(this.castleConfigurationProperties, "backend_provider", "CASTLE_SDK_BACKEND_PROVIDER");
        String authenticateFailoverStrategyValue = this.loadConfigurationValue(this.castleConfigurationProperties, "failover_strategy", "CASTLE_SDK_AUTHENTICATE_FAILOVER_STRATEGY");
        String apiBaseUrl = this.loadConfigurationValue(this.castleConfigurationProperties, "base_url", "CASTLE_SDK_BASE_URL");
        String logHttpRequests = this.loadConfigurationValue(this.castleConfigurationProperties, "log_http", "CASTLE_SDK_LOG_HTTP");
        String ipHeadersValue = this.loadConfigurationValue(this.castleConfigurationProperties, "ip_headers", "CASTLE_SDK_IP_HEADERS");
        CastleConfigurationBuilder builder = CastleConfigurationBuilder.defaultConfigBuilder().withApiSecret(envApiSecret).withCastleAppId(castleAppId);
        if (apiBaseUrl != null) {
            builder.withApiBaseUrl(apiBaseUrl);
        } else {
            builder.withDefaultApiBaseUrl();
        }
        if (allowListValue != null) {
            builder.withAllowListHeaders(Splitter.on((String)",").splitToList((CharSequence)allowListValue));
        }
        if (denyListValue != null) {
            builder.withDenyListHeaders(Splitter.on((String)",").splitToList((CharSequence)denyListValue));
        }
        if (timeoutValue != null) {
            int timeout = Integer.parseInt(timeoutValue);
            builder.withTimeout(timeout);
        }
        if (authenticateFailoverStrategyValue != null) {
            if (authenticateFailoverStrategyValue.compareTo("throw") == 0) {
                builder.withAuthenticateFailoverStrategy(new AuthenticateFailoverStrategy());
            } else {
                builder.withAuthenticateFailoverStrategy(new AuthenticateFailoverStrategy(AuthenticateAction.fromAction(authenticateFailoverStrategyValue)));
            }
        } else {
            builder.withDefaultAuthenticateFailoverStrategy();
        }
        if (backendProviderValue != null) {
            builder.withBackendProvider(CastleBackendProvider.valueOf(backendProviderValue));
        }
        if (logHttpRequests != null) {
            builder.withLogHttpRequests(Boolean.valueOf(logHttpRequests));
        }
        if (ipHeadersValue != null) {
            builder.withIPHeaders(Splitter.on((String)",").splitToList((CharSequence)ipHeadersValue));
        }
        return builder;
    }

    private String loadConfigurationValue(Properties properties, String propertyName, String environmentName) {
        String getenv = System.getenv(environmentName);
        if (getenv == null) {
            getenv = properties.getProperty(propertyName);
        }
        return getenv;
    }
}

