/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.utils;

import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.json.CastleGsonModel;
import io.castle.client.internal.utils.HeaderNormalizer;
import io.castle.client.model.CastleContext;
import io.castle.client.model.CastleDevice;
import io.castle.client.model.CastleHeader;
import io.castle.client.model.CastleHeaders;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CastleContextBuilder {
    private CastleContext context;
    private CastleHeaders headers;
    private final CastleGsonModel model;
    private final CastleConfiguration configuration;
    private final HeaderNormalizer headerNormalizer = new HeaderNormalizer();

    public CastleContextBuilder(CastleConfiguration configuration, CastleGsonModel model) {
        this.configuration = configuration;
        this.model = model;
        this.context = new CastleContext();
    }

    public CastleContext build() {
        this.context.setHeaders(this.headers);
        return this.context;
    }

    public CastleContextBuilder active(boolean active) {
        this.context.setActive(active);
        return this;
    }

    public CastleContextBuilder clientId(String clientId) {
        this.context.setClientId(clientId);
        return this;
    }

    public CastleContextBuilder clientId(boolean clientId) {
        this.context.setClientId(clientId);
        return this;
    }

    public CastleContextBuilder device(CastleDevice device) {
        this.context.setDevice(device);
        return this;
    }

    public CastleContextBuilder ip(String ip) {
        this.context.setIp(ip);
        return this;
    }

    public CastleContextBuilder headers(CastleHeaders headers) {
        this.headers = headers;
        return this;
    }

    public CastleContextBuilder userAgent(String userAgent) {
        this.context.setUserAgent(userAgent);
        return this;
    }

    public CastleContextBuilder userAgent(boolean userAgent) {
        this.context.setUserAgent(userAgent);
        return this;
    }

    public CastleContextBuilder fromHttpServletRequest(HttpServletRequest request) {
        this.context.setClientId(this.setClientIdFromHttpServletRequest(request));
        this.headers = this.setCastleHeadersFromHttpServletRequest(request);
        this.context.setUserAgent(this.setUserAgentFromHttpServletRequest(request));
        this.context.setIp(request.getRemoteAddr());
        if (this.configuration.getIpHeaders() != null) {
            for (String header : this.configuration.getIpHeaders()) {
                if (request.getHeader(header) == null) continue;
                this.context.setIp(request.getHeader(header));
                break;
            }
        }
        return this;
    }

    public CastleContextBuilder fromJson(String contextString) {
        this.context = (CastleContext)this.model.getGson().fromJson(contextString, CastleContext.class);
        this.headers = this.context.getHeaders();
        return this;
    }

    public String toJson() {
        return this.model.getGson().toJson((Object)this.build());
    }

    private CastleHeaders setCastleHeadersFromHttpServletRequest(HttpServletRequest request) {
        ArrayList<CastleHeader> castleHeadersList = new ArrayList<CastleHeader>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String headerValue = request.getHeader(key);
            this.addHeaderValue(castleHeadersList, key, headerValue);
        }
        this.addHeaderValue(castleHeadersList, "REMOTE_ADDR", request.getRemoteAddr());
        CastleHeaders headers = new CastleHeaders();
        headers.setHeaders(castleHeadersList);
        return headers;
    }

    private void addHeaderValue(ArrayList<CastleHeader> castleHeadersList, String key, String headerValue) {
        String keyNormalized = this.headerNormalizer.normalize(key);
        if (this.configuration.getDenyListHeaders().contains(keyNormalized)) {
            castleHeadersList.add(new CastleHeader(key, "true"));
            return;
        }
        if (this.configuration.getAllowListHeaders().isEmpty()) {
            castleHeadersList.add(new CastleHeader(key, headerValue));
        } else if (this.configuration.getAllowListHeaders().contains(keyNormalized)) {
            castleHeadersList.add(new CastleHeader(key, headerValue));
        } else {
            castleHeadersList.add(new CastleHeader(key, "true"));
        }
    }

    private Object setClientIdFromHttpServletRequest(HttpServletRequest request) {
        Cookie[] cookies;
        String cid = request.getHeader("X-Castle-Client-Id");
        if ((cid == null || cid.isEmpty()) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("__cid")) continue;
                cid = cookie.getValue();
            }
        }
        if (cid == null) {
            return false;
        }
        return cid;
    }

    private Object setUserAgentFromHttpServletRequest(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        return userAgent;
    }
}

