/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.utils;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;

public class ContextMerge {
    public JsonObject merge(JsonObject base, JsonObject addition) {
        if (addition == null) {
            return new JsonObject();
        }
        return this.mergeDeep(base, addition);
    }

    private JsonObject mergeDeep(JsonObject base, JsonObject addition) {
        Set baseProperties = base.keySet();
        Set additionProperties = addition.keySet();
        Sets.SetView onlyOnBase = Sets.difference((Set)baseProperties, (Set)additionProperties);
        Sets.SetView onlyOnAddition = Sets.difference((Set)additionProperties, (Set)baseProperties);
        Sets.SetView propertiesToMerge = Sets.intersection((Set)baseProperties, (Set)additionProperties);
        JsonObject result = new JsonObject();
        for (String baseProp : onlyOnBase) {
            this.addEntryToResult(result, baseProp, base.get(baseProp));
        }
        for (String additionProp : onlyOnAddition) {
            this.addEntryToResult(result, additionProp, addition.get(additionProp));
        }
        for (String key : propertiesToMerge) {
            JsonElement additionValue = addition.get(key);
            JsonElement baseValue = base.get(key);
            if (additionValue.isJsonNull()) {
                this.addEntryToResult(result, key, additionValue);
                continue;
            }
            if (additionValue.isJsonObject()) {
                if (baseValue.isJsonObject()) {
                    this.addEntryToResult(result, key, (JsonElement)this.mergeDeep(baseValue.getAsJsonObject(), additionValue.getAsJsonObject()));
                    continue;
                }
                if (baseValue.isJsonArray()) {
                    this.addEntryToResult(result, key, additionValue);
                    continue;
                }
                this.addEntryToResult(result, key, additionValue);
                continue;
            }
            if (additionValue.isJsonArray()) {
                if (baseValue.isJsonObject()) {
                    this.addEntryToResult(result, key, additionValue);
                    continue;
                }
                if (baseValue.isJsonArray()) {
                    this.addEntryToResult(result, key, (JsonElement)this.mergeDeep(baseValue.getAsJsonArray(), additionValue.getAsJsonArray()));
                    continue;
                }
                this.addEntryToResult(result, key, additionValue);
                continue;
            }
            this.addEntryToResult(result, key, additionValue);
        }
        return result;
    }

    private void addEntryToResult(JsonObject result, String key, JsonElement value) {
        if (value.isJsonObject()) {
            result.add(key, (JsonElement)this.deepCopy(value.getAsJsonObject()));
        } else if (value.isJsonArray()) {
            result.add(key, (JsonElement)this.deepCopy(value.getAsJsonArray()));
        } else if (value.isJsonPrimitive()) {
            result.add(key, (JsonElement)value.getAsJsonPrimitive());
        }
    }

    private JsonArray mergeDeep(JsonArray target, JsonArray source) {
        JsonArray result = this.deepCopy(target);
        for (JsonElement fromSource : source) {
            result.add(fromSource);
        }
        return result;
    }

    private JsonObject deepCopy(JsonObject jsonObject) {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            this.addEntryToResult(result, (String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return result;
    }

    private JsonArray deepCopy(JsonArray jsonArray) {
        JsonArray result = new JsonArray();
        for (JsonElement jsonElement : jsonArray) {
            if (jsonElement.isJsonObject()) {
                result.add((JsonElement)this.deepCopy(jsonElement.getAsJsonObject()));
                continue;
            }
            if (jsonElement.isJsonArray()) {
                result.add((JsonElement)this.deepCopy(jsonElement.getAsJsonArray()));
                continue;
            }
            result.add((JsonElement)new JsonPrimitive(jsonElement.getAsString()));
        }
        return result;
    }
}

