/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.utils;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.castle.client.model.CastleApiInternalServerErrorException;
import io.castle.client.model.CastleApiInvalidParametersException;
import io.castle.client.model.CastleApiInvalidRequestTokenException;
import io.castle.client.model.CastleApiNotFoundException;
import io.castle.client.model.CastleApiTimeoutException;
import io.castle.client.model.CastleRuntimeException;
import io.castle.client.model.CastleServerErrorException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Response;

public class OkHttpExceptionUtil {
    public static CastleRuntimeException handle(IOException e) {
        if (e instanceof SocketTimeoutException) {
            return new CastleApiTimeoutException(e);
        }
        return new CastleRuntimeException(e);
    }

    public static void handle(Response response) throws CastleServerErrorException {
        if (!response.isSuccessful() && !response.isRedirect()) {
            switch (response.code()) {
                case 500: {
                    throw new CastleApiInternalServerErrorException(response);
                }
                case 422: {
                    try {
                        String body = response.peekBody(Long.MAX_VALUE).string();
                        JsonObject json = (JsonObject)JsonParser.parseString((String)body);
                        String type = json.get("type").getAsString();
                        if (type.equals("invalid_request_token")) {
                            throw new CastleApiInvalidRequestTokenException(response);
                        }
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException throwable) {
                        // empty catch block
                    }
                    throw new CastleApiInvalidParametersException(response);
                }
                case 404: {
                    throw new CastleApiNotFoundException(response);
                }
            }
            throw new CastleServerErrorException(response);
        }
    }
}

