/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.utils;

import com.google.gson.JsonElement;
import io.castle.client.internal.utils.VerdictTransportModel;
import io.castle.client.model.AuthenticateAction;
import io.castle.client.model.RiskPolicyResult;
import io.castle.client.model.Verdict;

public class VerdictBuilder {
    private AuthenticateAction action;
    private RiskPolicyResult riskPolicy;
    private String userId;
    private boolean failover;
    private String failoverReason;
    private String deviceToken;
    private JsonElement internal;
    private float risk;

    private VerdictBuilder() {
    }

    public static VerdictBuilder success() {
        return new VerdictBuilder().withFailover(false);
    }

    public static VerdictBuilder failover(String failoverReason) {
        return new VerdictBuilder().withFailover(true).withFailoverReason(failoverReason);
    }

    public VerdictBuilder withAction(AuthenticateAction action) {
        this.action = action;
        return this;
    }

    public VerdictBuilder withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VerdictBuilder withRiskPolicy(RiskPolicyResult riskPolicy) {
        this.riskPolicy = riskPolicy;
        return this;
    }

    public VerdictBuilder withDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
        return this;
    }

    public VerdictBuilder withRisk(float risk) {
        this.risk = risk;
        return this;
    }

    public Verdict build() {
        Verdict verdict = new Verdict();
        verdict.setAction(this.action);
        verdict.setUserId(this.userId);
        verdict.setFailover(this.failover);
        verdict.setFailoverReason(this.failoverReason);
        verdict.setDeviceToken(this.deviceToken);
        verdict.setRiskPolicy(this.riskPolicy);
        verdict.setInternal(this.internal);
        verdict.setRisk(this.risk);
        return verdict;
    }

    public VerdictBuilder withFailover(boolean failover) {
        this.failover = failover;
        return this;
    }

    public VerdictBuilder withFailoverReason(String failoverReason) {
        this.failoverReason = failoverReason;
        return this;
    }

    public VerdictBuilder withInternal(JsonElement internal) {
        this.internal = internal;
        return this;
    }

    public static Verdict fromTransport(VerdictTransportModel transport, JsonElement internal) {
        internal.getAsJsonObject().get("action").getAsString();
        return VerdictBuilder.success().withAction(transport.getAction()).withUserId(transport.getUserId()).withDeviceToken(transport.getDeviceToken()).withRiskPolicy(transport.getRiskPolicy()).withRisk(transport.getRisk()).withInternal(internal).build();
    }
}

