/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model;

import io.castle.client.model.CastleContext;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class CastleMessage {
    private transient CastleContext context;
    private String createdAt;
    private String timestamp;
    private String deviceToken;
    @Nonnull
    private String event;
    private transient HashMap other;
    private Object properties;
    private String reviewId;
    private String userId;
    private Object userTraits;

    public CastleMessage(String event) {
        this.setEvent(event);
    }

    public CastleContext getContext() {
        return this.context;
    }

    public void setContext(CastleContext context) {
        this.context = context;
    }

    @Deprecated
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Deprecated
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    @Nonnull
    public String getEvent() {
        return this.event;
    }

    public void setEvent(@Nonnull String event) {
        this.event = event;
    }

    public HashMap getOther() {
        if (this.other == null) {
            this.other = new HashMap();
        }
        return this.other;
    }

    public void setOther(HashMap other) {
        this.other = other;
    }

    public Object getProperties() {
        return this.properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public String getReviewId() {
        return this.reviewId;
    }

    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Object getUserTraits() {
        return this.userTraits;
    }

    public void setUserTraits(Object userTraits) {
        this.userTraits = userTraits;
    }

    public static Builder builder(String event) {
        return new Builder(new CastleMessage(event));
    }

    public static class Builder {
        private CastleMessage payload;

        public Builder(CastleMessage payload) {
            this.payload = payload;
        }

        public CastleMessage build() {
            return this.payload;
        }

        public Builder context(CastleContext context) {
            this.payload.setContext(context);
            return this;
        }

        @Deprecated
        public Builder createdAt(String createdAt) {
            this.payload.setCreatedAt(createdAt);
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.payload.setTimestamp(timestamp);
            return this;
        }

        public Builder deviceToken(String deviceToken) {
            this.payload.setDeviceToken(deviceToken);
            return this;
        }

        public Builder reviewId(String reviewId) {
            this.payload.setReviewId(reviewId);
            return this;
        }

        public Builder properties(Object properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.payload.setProperties(properties);
            return this;
        }

        public Builder other(HashMap other) {
            this.payload.setOther(other);
            return this;
        }

        public Builder put(String key, Object value) {
            this.payload.getOther().put(key, value);
            return this;
        }

        public Builder userId(String userId) {
            this.payload.setUserId(userId);
            return this;
        }

        public Builder userTraits(Object userTraits) {
            if (userTraits == null) {
                throw new NullPointerException("Null userTraits");
            }
            this.payload.setUserTraits(userTraits);
            return this;
        }
    }
}

