/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class Address {
    public static final String SERIALIZED_NAME_LINE1 = "line1";
    @SerializedName(value="line1")
    private String line1;
    public static final String SERIALIZED_NAME_LINE2 = "line2";
    @SerializedName(value="line2")
    private String line2;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
    @SerializedName(value="country_code")
    private String countryCode;
    public static final String SERIALIZED_NAME_REGION_CODE = "region_code";
    @SerializedName(value="region_code")
    private String regionCode;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_FINGERPRINT = "fingerprint";
    @SerializedName(value="fingerprint")
    private String fingerprint;

    public Address line1(String line1) {
        this.line1 = line1;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="60 Rausch Street", value="")
    public String getLine1() {
        return this.line1;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public Address line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getLine2() {
        return this.line2;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="San Francisco", value="Name of the city associated to this address.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", required=true, value="ISO-3166 country code")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Address regionCode(String regionCode) {
        this.regionCode = regionCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CA", value="ISO region code")
    public String getRegionCode() {
        return this.regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="94103", value="")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a33j2lir9", value="")
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.line1, address.line1) && Objects.equals(this.line2, address.line2) && Objects.equals(this.city, address.city) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.regionCode, address.regionCode) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.fingerprint, address.fingerprint);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && a.get().getClass().isArray() ? Arrays.equals((Object[])a.get(), (Object[])b.get()) : Objects.equals(a.get(), b.get()));
    }

    public int hashCode() {
        return Objects.hash(this.line1, this.line2, this.city, this.countryCode, this.regionCode, this.postalCode, this.fingerprint);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? (a.get().getClass().isArray() ? Arrays.hashCode((Object[])a.get()) : Objects.hashCode(a.get())) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    line1: ").append(this.toIndentedString(this.line1)).append("\n");
        sb.append("    line2: ").append(this.toIndentedString(this.line2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    regionCode: ").append(this.toIndentedString(this.regionCode)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

