/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.annotations.SerializedName;
import io.castle.client.model.generated.BaseChangesetEntry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing information about attributes that changed due to the event. You can send either anonymous attributes (eg. to track password changes) or full attributes (eg. email changes). To simplify your implementation, Castle *automatically* tracks changes to name, email, and phone, however, if you have the `from` and `to` values at hand, you can also send the changeset yourself, which also allows you to specify changes a user\u2019s password as well as any other custom attributes. Changes to custom attributes won\u2019t be searchable in the dashboard, but they will appear in the event stream.")
public class Changeset {
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private BaseChangesetEntry password;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private BaseChangesetEntry email;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    private BaseChangesetEntry phone;
    public static final String SERIALIZED_NAME_AUTHENTICATION_METHOD_TYPE = "authentication_method.type";
    @SerializedName(value="authentication_method.type")
    private BaseChangesetEntry authenticationMethodType;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private BaseChangesetEntry name;

    public Changeset password(BaseChangesetEntry password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BaseChangesetEntry getPassword() {
        return this.password;
    }

    public void setPassword(BaseChangesetEntry password) {
        this.password = password;
    }

    public Changeset email(BaseChangesetEntry email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Email address change. You can also inform Castle that the email changed without sending the values explicitly: `{ \"email\": { \"changed\": true } }`")
    public BaseChangesetEntry getEmail() {
        return this.email;
    }

    public void setEmail(BaseChangesetEntry email) {
        this.email = email;
    }

    public Changeset phone(BaseChangesetEntry phone) {
        this.phone = phone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Phone number change. You can also inform Castle that the phone changed without sending the values explicitly: `{ \"phone\": { \"changed\": true } }`")
    public BaseChangesetEntry getPhone() {
        return this.phone;
    }

    public void setPhone(BaseChangesetEntry phone) {
        this.phone = phone;
    }

    public Changeset authenticationMethodType(BaseChangesetEntry authenticationMethodType) {
        this.authenticationMethodType = authenticationMethodType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BaseChangesetEntry getAuthenticationMethodType() {
        return this.authenticationMethodType;
    }

    public void setAuthenticationMethodType(BaseChangesetEntry authenticationMethodType) {
        this.authenticationMethodType = authenticationMethodType;
    }

    public Changeset name(BaseChangesetEntry name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BaseChangesetEntry getName() {
        return this.name;
    }

    public void setName(BaseChangesetEntry name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)o;
        return Objects.equals(this.password, changeset.password) && Objects.equals(this.email, changeset.email) && Objects.equals(this.phone, changeset.phone) && Objects.equals(this.authenticationMethodType, changeset.authenticationMethodType) && Objects.equals(this.name, changeset.name) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.password, this.email, this.phone, this.authenticationMethodType, this.name, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Changeset {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    authenticationMethodType: ").append(this.toIndentedString(this.authenticationMethodType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

