/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.annotations.SerializedName;
import io.castle.client.model.generated.BaseChangesetEntry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information that the attribute changed along with the changed values. Examples: `{ \"email\": { \"from\": \"a@example.com\", \"to\": \"b@example.com\" }`, `{ \"authentication_method.type\": { \"from\": null, \"to\": \"$push\" }`")
public class ChangesetEntry
extends BaseChangesetEntry {
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private String to;

    public ChangesetEntry from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Attribute value before the event")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ChangesetEntry to(String to) {
        this.to = to;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Attribute value after the event")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangesetEntry changesetEntry = (ChangesetEntry)o;
        return Objects.equals(this.from, changesetEntry.from) && Objects.equals(this.to, changesetEntry.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangesetEntry {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

