/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Context {
    public static final String SERIALIZED_NAME_HEADERS = "headers";
    @SerializedName(value="headers")
    private List<List<String>> headers = new ArrayList<List<String>>();
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    private String ip;

    public Context headers(List<List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public Context addHeadersItem(String key, String value) {
        this.headers.add(Arrays.asList(key, value));
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[[\"User-Agent\",\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.1 Safari/605.1.15\"],[\"Accept-Encoding\",\"gzip, deflate, br\"],[\"Accept-Language\",\"en-us\"],[\"Accept\",\"text/html,application/xhtml+xml,application/xml;q=0.9,*_/_*;q=0.8\"],[\"Connection\",\"close\"],[\"Host\",\"castle.io\"]]", required=true, value="The Headers object of the originating request.  For best results, it's recommended to forward all headers from the originating request. At minimum, the following headers should be forwarded: `Host`, `User-Agent`, `Accept`, `Accept-Encoding`, `Accept-Language`. ")
    public List<List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<List<String>> headers) {
        this.headers = headers;
    }

    public Context ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="211.96.77.55", required=true, value="The IPv4 or IPv6 address of the originating request. Must be a valid, public IP. Supports ipv4 and ipv6 ")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.headers, context.headers) && Objects.equals(this.ip, context.ip);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.ip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Context {\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

