/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.annotations.SerializedName;
import io.castle.client.model.generated.DeviceContext;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

public class Device {
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_LAST_SEEN_AT = "last_seen_at";
    @SerializedName(value="last_seen_at")
    private OffsetDateTime lastSeenAt;
    public static final String SERIALIZED_NAME_APPROVED_AT = "approved_at";
    @SerializedName(value="approved_at")
    private OffsetDateTime approvedAt;
    public static final String SERIALIZED_NAME_ESCALATED_AT = "escalated_at";
    @SerializedName(value="escalated_at")
    private OffsetDateTime escalatedAt;
    public static final String SERIALIZED_NAME_MITIGATED_AT = "mitigated_at";
    @SerializedName(value="mitigated_at")
    private OffsetDateTime mitigatedAt;
    public static final String SERIALIZED_NAME_IS_CURRENT_DEVICE = "is_current_device";
    @SerializedName(value="is_current_device")
    private Boolean isCurrentDevice;
    public static final String SERIALIZED_NAME_CONTEXT = "context";
    @SerializedName(value="context")
    private DeviceContext context;

    @Nonnull
    @ApiModelProperty(example="eyJhbGciOiJIUzI1NiJ9.eyJhIjoxfQ.CLqLzOmK8uYmIXNlhPXhrWCTQOT-XO2Vx8pB2Xqol4g", required=true, value="Unique identifier for a user's device. This value may change over time and **should not** be used as a stable reference to the device")
    public String getToken() {
        return this.token;
    }

    @Nonnull
    @ApiModelProperty(example="262ad900-b126-44df-9564-689f30391c57", required=true, value="")
    public String getUserId() {
        return this.userId;
    }

    @Nonnull
    @ApiModelProperty(example="2012-12-02T00:30:08.276Z", required=true, value="The time and date on which the device was created")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    @ApiModelProperty(example="2012-12-02T00:30:08.276Z", required=true, value="The time and date on which the device was last used")
    public OffsetDateTime getLastSeenAt() {
        return this.lastSeenAt;
    }

    @Nullable
    @ApiModelProperty(example="2012-12-02T00:30:08.276Z", required=true, value="The time and date on which the device was approved")
    public OffsetDateTime getApprovedAt() {
        return this.approvedAt;
    }

    @Nullable
    @ApiModelProperty(example="2012-12-02T00:30:08.276Z", required=true, value="The time and date on which the device was escalated")
    public OffsetDateTime getEscalatedAt() {
        return this.escalatedAt;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public OffsetDateTime getMitigatedAt() {
        return this.mitigatedAt;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getIsCurrentDevice() {
        return this.isCurrentDevice;
    }

    public Device context(DeviceContext context) {
        this.context = context;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public DeviceContext getContext() {
        return this.context;
    }

    public void setContext(DeviceContext context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.token, device.token) && Objects.equals(this.userId, device.userId) && Objects.equals(this.createdAt, device.createdAt) && Objects.equals(this.lastSeenAt, device.lastSeenAt) && Objects.equals(this.approvedAt, device.approvedAt) && Objects.equals(this.escalatedAt, device.escalatedAt) && Objects.equals(this.mitigatedAt, device.mitigatedAt) && Objects.equals(this.isCurrentDevice, device.isCurrentDevice) && Objects.equals(this.context, device.context);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.userId, this.createdAt, this.lastSeenAt, this.approvedAt, this.escalatedAt, this.mitigatedAt, this.isCurrentDevice, this.context);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Device {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastSeenAt: ").append(this.toIndentedString(this.lastSeenAt)).append("\n");
        sb.append("    approvedAt: ").append(this.toIndentedString(this.approvedAt)).append("\n");
        sb.append("    escalatedAt: ").append(this.toIndentedString(this.escalatedAt)).append("\n");
        sb.append("    mitigatedAt: ").append(this.toIndentedString(this.mitigatedAt)).append("\n");
        sb.append("    isCurrentDevice: ").append(this.toIndentedString(this.isCurrentDevice)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

